/*
 * Decompiled with CFR 0.152.
 */
package top.liyf.net.http;

import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import top.liyf.net.http.HttpClientResult;

public class HttpClientUtil {
    private static final String UTF8 = "UTF-8";
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int SOCKET_TIMEOUT = 6000;

    public static HttpClientResult doGet(String url) throws Exception {
        return HttpClientUtil.doGet(url, null, null);
    }

    public static HttpClientResult doGet(String url, Map<String, String> params) throws Exception {
        return HttpClientUtil.doGet(url, null, params);
    }

    public static HttpClientResult doGet(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        URIBuilder uriBuilder = new URIBuilder(url);
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(6000).build();
        httpGet.setConfig(requestConfig);
        HttpClientUtil.packageHeader(headers, (HttpRequestBase)httpGet);
        try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);){
            HttpClientResult httpClientResult = HttpClientUtil.getHttpClientResult(httpResponse);
            return httpClientResult;
        }
    }

    private static void packageHeader(Map<String, String> params, HttpRequestBase httpMethod) {
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                httpMethod.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private static HttpClientResult getHttpClientResult(CloseableHttpResponse httpResponse) throws Exception {
        if (httpResponse != null && httpResponse.getStatusLine() != null) {
            String content = "";
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                content = EntityUtils.toString((HttpEntity)entity, (String)UTF8);
            }
            return new HttpClientResult(httpResponse.getStatusLine().getStatusCode(), content);
        }
        return new HttpClientResult(500);
    }
}

