/*
 * Decompiled with CFR 0.152.
 */
package top.liyf.time;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class TimeUtil {
    public static long intervalDays(LocalDate endDate) {
        return TimeUtil.intervalDays(LocalDate.now(), endDate);
    }

    public static long intervalDays(LocalDate startDate, LocalDate endDate) {
        return startDate.until(endDate, ChronoUnit.DAYS);
    }

    public static long intervalDays(ZonedDateTime endDate) {
        ZoneId zone = endDate.getZone();
        return TimeUtil.intervalDays(ZonedDateTime.now(zone), endDate);
    }

    public static long intervalDays(ZonedDateTime startDate, ZonedDateTime endDate) {
        ZonedDateTime startDateZero = startDate.truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime endDateZero = endDate.with(LocalTime.MIN);
        return startDateZero.until(endDateZero, ChronoUnit.DAYS);
    }
}

