/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.apollo.config;

import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApolloRefresherConfiguration
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ApolloRefresherConfiguration.class);
    private ApplicationContext applicationContext;

    @ApolloConfigChangeListener
    private void configRefresher(ConfigChangeEvent changeEvent) {
        for (String key : changeEvent.changedKeys()) {
            ConfigChange change = changeEvent.getChange(key);
            log.debug("Found change - {}", (Object)change.toString());
        }
        this.applicationContext.publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changeEvent.changedKeys()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

