/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.common.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class JsonResponse<R>
implements Serializable {
    private static final long serialVersionUID = 7574078101944305355L;
    private static final int default_failure_code = 500000;
    private static final String default_failure_message = "\u7cfb\u7edf\u7e41\u5fd9, \u8bf7\u7a0d\u540e\u91cd\u8bd5";
    private static final String default_success_message = "success";
    private boolean status;
    private int code;
    private String message;
    private R data;
    private final Map<String, Object> otherData = new HashMap<String, Object>();

    public static <R> JsonResponse<R> build() {
        return new JsonResponse<R>();
    }

    public static <R> JsonResponse<R> failure() {
        return JsonResponse.failure(default_failure_message);
    }

    public static <R> JsonResponse<R> failure(String message) {
        return JsonResponse.failure(500000, message);
    }

    public static <R> JsonResponse<R> failure(int code, String message) {
        JsonResponse<R> jsonResponse = JsonResponse.build();
        jsonResponse.status = false;
        jsonResponse.code = code;
        jsonResponse.message = message;
        return jsonResponse;
    }

    public static <R> JsonResponse<R> success() {
        JsonResponse<R> jsonResponse = JsonResponse.build();
        jsonResponse.status = true;
        jsonResponse.message = default_success_message;
        return jsonResponse;
    }

    public static <R> JsonResponse<R> success(R data) {
        JsonResponse<R> jsonResponse = JsonResponse.success();
        jsonResponse.data = data;
        return jsonResponse;
    }

    public static <R> JsonResponse<R> successMessage(String message) {
        JsonResponse<R> jsonResponse = JsonResponse.success();
        jsonResponse.message = message;
        return jsonResponse;
    }

    public JsonResponse<R> data(R data) {
        this.data = data;
        return this;
    }

    public JsonResponse<R> otherData(Map<String, ? extends Object> otherData) {
        this.otherData.putAll(otherData);
        return this;
    }

    public JsonResponse<R> otherData(String key, Object value) {
        this.otherData.put(key, value);
        return this;
    }

    public JsonResponse<R> message(String message) {
        this.message = message;
        return this;
    }

    public JsonResponse<R> code(int code) {
        this.code = code;
        return this;
    }

    public boolean isStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public R getData() {
        return this.data;
    }

    public JsonResponse<R> setStatus(boolean status) {
        this.status = status;
        return this;
    }

    public JsonResponse<R> setCode(int code) {
        this.code = code;
        return this;
    }

    public JsonResponse<R> setMessage(String message) {
        this.message = message;
        return this;
    }

    public JsonResponse<R> setData(R data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonResponse)) {
            return false;
        }
        JsonResponse other = (JsonResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStatus() != other.isStatus()) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        R this$data = this.getData();
        R other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, Object> this$otherData = this.getOtherData();
        Map<String, Object> other$otherData = other.getOtherData();
        return !(this$otherData == null ? other$otherData != null : !((Object)this$otherData).equals(other$otherData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStatus() ? 79 : 97);
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        R $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, Object> $otherData = this.getOtherData();
        result = result * 59 + ($otherData == null ? 43 : ((Object)$otherData).hashCode());
        return result;
    }

    public String toString() {
        return "JsonResponse(status=" + this.isStatus() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", otherData=" + this.getOtherData() + ")";
    }

    public Map<String, Object> getOtherData() {
        return this.otherData;
    }
}

