/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.core.converter;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;

public class FastJsonConverter {
    private static final Logger log = LoggerFactory.getLogger(FastJsonConverter.class);

    public static FastJsonHttpMessageConverter create() {
        return FastJsonConverter.fastJsonHttpMessageConverter("yyyy-MM-dd HH:mm:ss");
    }

    public static FastJsonHttpMessageConverter create(String dateFormat) {
        if (StringUtils.isEmpty((Object)dateFormat)) {
            return FastJsonConverter.create();
        }
        return FastJsonConverter.fastJsonHttpMessageConverter(dateFormat);
    }

    private static FastJsonHttpMessageConverter fastJsonHttpMessageConverter(String dateFormat) {
        log.info("Init fastJson HttpMessageConverter...");
        FastJsonHttpMessageConverter fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(MediaType.parseMediaType((String)"text/html;charset=UTF-8"));
        supportedMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        fastJsonHttpMessageConverter.setSupportedMediaTypes(supportedMediaTypes);
        fastJsonHttpMessageConverter.setFastJsonConfig(FastJsonConverter.getFastJsonConfig(dateFormat));
        return fastJsonHttpMessageConverter;
    }

    private static FastJsonConfig getFastJsonConfig(String dateFormat) {
        log.debug("Init fastJson config...");
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        ArrayList<SerializerFeature> serializerFeatureList = new ArrayList<SerializerFeature>();
        serializerFeatureList.add(SerializerFeature.WriteNullStringAsEmpty);
        SerializerFeature[] serializerFeatures = serializerFeatureList.toArray(new SerializerFeature[serializerFeatureList.size()]);
        fastJsonConfig.setSerializerFeatures(serializerFeatures);
        fastJsonConfig.setDateFormat(dateFormat);
        return fastJsonConfig;
    }
}

