package top.lshaci.framework.dingtalk.properties;

import cn.hutool.core.util.StrUtil;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;

/**
 * DingTalkProperties
 *
 * @author lshaci
 * @since 1.0.8
 */
@Data
@Valid
@ConfigurationProperties(DingTalkProperties.PREFIX)
public class DingTalkProperties {

    /**
     * 配置前缀
     */
    public static final String PREFIX = "framework.dingtalk";

    /**
     * 是否启用钉钉机器人配置
     */
    private boolean enabled = true;

    /**
     * 钉钉群机器人发送消息地址
     */
    @NotBlank
    private String serverUrl = "https://oapi.dingtalk.com/robot/send";

    /**
     * 群机器人的access_token
     */
    @NotBlank
    private String accessToken;

    /**
     * 加签方式的密钥
     */
    private String secret;

    /**
     * 获取钉钉服务地址
     *
     * @return 钉钉服务地址
     */
    public String getServerUrl() {
        return StrUtil.format("{}?access_token={}", serverUrl, accessToken);
    }
}
