package top.lshaci.framework.dingtalk.service;

import com.dingtalk.api.request.OapiRobotSendRequest;
import com.dingtalk.api.response.OapiRobotSendResponse;
import com.taobao.api.ApiException;
import top.lshaci.framework.dingtalk.enums.DingTalkMsgType;
import top.lshaci.framework.dingtalk.util.DingTalkRequestUtil;

/**
 * DingTalkService
 *
 * @author lshaci
 * @since 1.0.8
 */
public interface DingTalkService {

    /**
     * 发送请求到钉钉
     *
     * @param request 请求信息
     * @return 响应信息
     */
    OapiRobotSendResponse execute(OapiRobotSendRequest request) throws ApiException;

    /**
     * 发送text请求到钉钉
     *
     * @param text 请求内容
     * @param at   被@人的手机号
     * @return 响应信息
     */
    default OapiRobotSendResponse execute(OapiRobotSendRequest.Text text, OapiRobotSendRequest.At at) throws ApiException {
        OapiRobotSendRequest request = DingTalkRequestUtil.of(DingTalkMsgType.text, at);
        request.setText(text);
        return execute(request);
    }

    /**
     * 发送link请求到钉钉
     *
     * @param link 请求内容
     * @param at   被@人的手机号
     * @return 响应信息
     */
    default OapiRobotSendResponse execute(OapiRobotSendRequest.Link link, OapiRobotSendRequest.At at) throws ApiException {
        OapiRobotSendRequest request = DingTalkRequestUtil.of(DingTalkMsgType.link, at);
        request.setLink(link);
        return execute(request);
    }

    /**
     * 发送markdown请求到钉钉
     *
     * @param markdown 请求内容
     * @param at       被@人的手机号
     * @return 响应信息
     */
    default OapiRobotSendResponse execute(OapiRobotSendRequest.Markdown markdown, OapiRobotSendRequest.At at) throws ApiException {
        OapiRobotSendRequest request = DingTalkRequestUtil.of(DingTalkMsgType.markdown, at);
        request.setMarkdown(markdown);
        return execute(request);
    }
}
