package top.lshaci.framework.dingtalk.util;

import com.dingtalk.api.request.OapiRobotSendRequest;
import top.lshaci.framework.dingtalk.enums.DingTalkMsgType;

/**
 * DingTalkRequestUtil
 *
 * @author lshaci
 * @since 1.0.8
 */
public class DingTalkRequestUtil {

    /**
     * 创建钉钉请求对象
     *
     * @param msgType 消息类型
     * @param at      被@人的手机号
     * @return 钉钉请求对象
     */
    public static OapiRobotSendRequest of(DingTalkMsgType msgType, OapiRobotSendRequest.At at) {
        OapiRobotSendRequest request = new OapiRobotSendRequest();
        request.setMsgtype(msgType.name());
        request.setAt(at);
        return request;
    }
}
