/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.druid.config;

import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:druidFilter.properties"})
public class DruidFilterConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidFilterConfig.class);
    @Value(value="${druid.wallFilter.logViolation}")
    private boolean logViolation;
    @Autowired(required=false)
    @Qualifier(value="dataSource")
    private DruidDataSource dataSource;
    @Autowired(required=false)
    @Qualifier(value="firstDataSource")
    private DruidDataSource firstDataSource;
    @Autowired(required=false)
    @Qualifier(value="secondDataSource")
    private DruidDataSource secondDataSource;

    @Bean(name={"wallConfig"})
    @ConfigurationProperties(value="druid.wallFilter.config")
    public WallConfig wallConfig() {
        log.info("Init Druid Wall Filter Config...");
        return new WallConfig();
    }

    @Bean
    public WallFilter wallFilter(WallConfig wallConfig) {
        log.info("Init Druid Wall Filter...");
        WallFilter wallFilter = new WallFilter();
        wallFilter.setLogViolation(this.logViolation);
        wallFilter.setConfig(wallConfig);
        return wallFilter;
    }

    @Bean
    @ConfigurationProperties(value="druid.statFilter")
    public StatFilter statFilter() {
        log.info("Init Druid Stat Filter...");
        return new StatFilter();
    }

    @Bean
    @ConfigurationProperties(value="druid.logFilter")
    public Slf4jLogFilter logFilter() {
        log.info("Init Druid Log Filter...");
        return new Slf4jLogFilter();
    }

    @PostConstruct
    private void initDataSourceFilter() {
        List<Filter> filters = Arrays.asList(this.statFilter(), this.wallFilter(this.wallConfig()), this.logFilter());
        log.info("Start set Druid Filters...");
        for (Filter filter : filters) {
            log.info("\t --> Filter class name is : " + filter.getClass().getName());
        }
        log.info("End set Druid Filters...");
        if (this.dataSource != null) {
            this.dataSource.clearFilters();
            this.dataSource.setProxyFilters(filters);
        }
        if (this.firstDataSource != null) {
            this.firstDataSource.clearFilters();
            this.firstDataSource.setProxyFilters(filters);
        }
        if (this.secondDataSource != null) {
            this.secondDataSource.clearFilters();
            this.secondDataSource.setProxyFilters(filters);
        }
    }
}

