/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.druid.config;

import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.support.http.WebStatFilter;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:druidWeb.properties"})
public class DruidWebConfig {
    private static final Logger log = LoggerFactory.getLogger(DruidWebConfig.class);
    @Value(value="${druid.statViewServlet.allowIp}")
    private String allowIp;
    @Value(value="${druid.statViewServlet.denyIp}")
    private String denyIp;
    @Value(value="${druid.statViewServlet.username}")
    private String username;
    @Value(value="${druid.statViewServlet.password}")
    private String password;
    @Value(value="${druid.statViewServlet.resetEnable}")
    private String resetEnable;
    @Value(value="${druid.webStatFilter.exclusions}")
    private String exclusions;
    @Value(value="${druid.webStatFilter.sessionStatMaxCount}")
    private String sessionStatMaxCount;
    @Value(value="${druid.webStatFilter.profileEnable}")
    private String profileEnable;

    @Bean
    public ServletRegistrationBean druidStatViewServlet() {
        log.info("Init Druid Web Stat View Servlet...");
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new StatViewServlet(), new String[]{"/druid/*"});
        servletRegistrationBean.addInitParameter("allow", this.allowIp);
        servletRegistrationBean.addInitParameter("deny", this.denyIp);
        servletRegistrationBean.addInitParameter("loginUsername", this.username);
        servletRegistrationBean.addInitParameter("loginPassword", this.password);
        servletRegistrationBean.addInitParameter("resetEnable", this.resetEnable);
        return servletRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean druidWebStatFilter() {
        log.info("Init Druid Web Stat Filter...");
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new WebStatFilter(), new ServletRegistrationBean[0]);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.addInitParameter("exclusions", this.exclusions);
        filterRegistrationBean.addInitParameter("sessionStatMaxCount", this.sessionStatMaxCount);
        filterRegistrationBean.addInitParameter("profileEnable", this.profileEnable);
        return filterRegistrationBean;
    }
}

