/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handler;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.DownloadConvert;
import top.lshaci.framework.excel.annotation.DownloadExcelSheet;
import top.lshaci.framework.excel.annotation.DownloadExcelTitle;
import top.lshaci.framework.excel.annotation.DownloadIgnore;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.model.DownloadOrder;
import top.lshaci.framework.excel.model.ExcelRelationModel;
import top.lshaci.framework.utils.ReflectionUtils;

public abstract class POIExcelDownloadHandler {
    private static final Logger log = LoggerFactory.getLogger(POIExcelDownloadHandler.class);

    /*
     * Exception decompiling
     */
    public static <E> ByteArrayOutputStream entities2Excel(List<E> entities) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setSheetRows(XSSFWorkbook workbook, XSSFSheet sheet, List<String[]> rowDatas) {
        XSSFCellStyle contentStyle = POIExcelDownloadHandler.createContentStyle(workbook);
        for (int i = 0; i < rowDatas.size(); ++i) {
            XSSFRow row = sheet.createRow(1 + i);
            row.setHeight((short)320);
            String[] rowData = rowDatas.get(i);
            for (int j = 0; j <= rowData.length; ++j) {
                XSSFCell cell = row.createCell(j);
                String value = j == 0 ? i + 1 + "" : rowData[j - 1];
                cell.setCellValue(value);
                cell.setCellStyle((CellStyle)contentStyle);
            }
        }
    }

    private static XSSFCellStyle createContentStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.WHITE));
        POIExcelDownloadHandler.setBorder(style);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)10);
        font.setFontName("\u5b8b\u4f53");
        style.setFont((Font)font);
        return style;
    }

    private static void setColumnTitles(XSSFWorkbook workbook, XSSFSheet sheet, List<DownloadOrder> titleOrder) {
        XSSFRow row = sheet.createRow(0);
        row.setHeight((short)360);
        XSSFCellStyle columnTitleStyle = POIExcelDownloadHandler.createColumnTitleStyle(workbook);
        for (int i = 0; i <= titleOrder.size(); ++i) {
            XSSFCell cell = row.createCell(i);
            String value = i == 0 ? "\u5e8f\u53f7" : titleOrder.get(i - 1).getTitle();
            cell.setCellValue(value);
            cell.setCellStyle((CellStyle)columnTitleStyle);
        }
    }

    private static XSSFCellStyle createColumnTitleStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.WHITE));
        POIExcelDownloadHandler.setBorder(style);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        style.setFont((Font)font);
        return style;
    }

    private static void setBorder(XSSFCellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static <E> List<String[]> entities2StringArrays(List<E> entities, List<DownloadOrder> titleOrder, Class<?> entityClass) {
        if (CollectionUtils.isEmpty(titleOrder)) {
            log.error("The title is empty");
            throw new ExcelHandlerException("The download excel title must not be empty!");
        }
        Map<String, ExcelRelationModel> handlerRelations = POIExcelDownloadHandler.handlerRelations(entityClass);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (E entity : entities) {
            int length = titleOrder.size();
            String[] row = new String[length];
            for (int i = 0; i < length; ++i) {
                DownloadOrder downloadOrder = titleOrder.get(i);
                Field field = downloadOrder.getField();
                String title = downloadOrder.getTitle();
                Object value = ReflectionUtils.getFieldValue(entity, (Field)field);
                ExcelRelationModel relationModel = handlerRelations.get(title);
                if (relationModel != null) {
                    value = POIExcelDownloadHandler.getConvertValue(value, relationModel);
                }
                row[i] = value != null ? value.toString() : "";
            }
            rows.add(row);
        }
        return rows;
    }

    private static Object getConvertValue(Object value, ExcelRelationModel relationModel) {
        Method method = relationModel.getConvertMethod();
        if (method != null) {
            Object instance = relationModel.getConvertInstance();
            Object convertValue = ReflectionUtils.invokeMethod((Object)instance, (Method)method, (Object[])new Object[]{value});
            return convertValue == null ? "" : convertValue.toString();
        }
        return value;
    }

    private static <E> Map<String, ExcelRelationModel> handlerRelations(Class<E> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("The entity not has any field!");
        }
        HashMap convertClassCache = new HashMap();
        return Arrays.stream(fields).filter(f -> f.getAnnotation(DownloadIgnore.class) == null).collect(Collectors.toMap(f -> POIExcelDownloadHandler.getFieldTitleName(f), f -> POIExcelDownloadHandler.createExcelRelationModel(f, convertClassCache)));
    }

    private static String getFieldTitleName(Field field) {
        DownloadExcelTitle excelTitle = field.getAnnotation(DownloadExcelTitle.class);
        if (excelTitle != null) {
            return excelTitle.title();
        }
        return field.getName();
    }

    private static Object getConvertInstance(Map<Class<?>, Object> convertClassCache, DownloadConvert convert) {
        Class<?> convertClass = convert.clazz();
        if (convertClass == null) {
            throw new ExcelHandlerException("The convert class must not be null!");
        }
        Object convertInstance = convertClassCache.get(convertClass);
        if (convertInstance == null) {
            convertInstance = ReflectionUtils.newInstance(convertClass);
            convertClassCache.put(convertClass, convertInstance);
        }
        return convertInstance;
    }

    private static Method getConvertMethod(DownloadConvert convert, Class<?> clazz) {
        String methodName = convert.method();
        Class<?> convertClass = convert.clazz();
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new ExcelHandlerException("The convert method name must not be empty!");
        }
        try {
            return convertClass.getDeclaredMethod(methodName, clazz);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "Get the convert method is error!";
            log.error(msg, (Throwable)e);
            throw new ExcelHandlerException(msg);
        }
    }

    private static ExcelRelationModel createExcelRelationModel(Field field, Map<Class<?>, Object> convertClassCache) {
        ExcelRelationModel model = new ExcelRelationModel(field);
        DownloadConvert convert = field.getAnnotation(DownloadConvert.class);
        if (convert != null) {
            Object convertInstance = POIExcelDownloadHandler.getConvertInstance(convertClassCache, convert);
            Method convertMethod = POIExcelDownloadHandler.getConvertMethod(convert, field.getType());
            model.setConvertInstance(convertInstance);
            model.setConvertMethod(convertMethod);
        }
        return model;
    }

    private static List<DownloadOrder> getTitleOrder(Class<?> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("The entity not has any field!");
        }
        return Arrays.stream(fields).filter(f -> f.getAnnotation(DownloadIgnore.class) == null).map(f -> POIExcelDownloadHandler.createDownloadOrder(f)).sorted().collect(Collectors.toList());
    }

    private static String getSheetName(Class<?> entityClass) {
        DownloadExcelSheet downloadExcelSheet = entityClass.getAnnotation(DownloadExcelSheet.class);
        if (downloadExcelSheet == null || StringUtils.isEmpty((CharSequence)downloadExcelSheet.value())) {
            return entityClass.getSimpleName();
        }
        return downloadExcelSheet.value();
    }

    private static DownloadOrder createDownloadOrder(Field field) {
        DownloadExcelTitle downloadExcelTitle = field.getAnnotation(DownloadExcelTitle.class);
        DownloadOrder downloadOrder = new DownloadOrder();
        downloadOrder.setField(field);
        if (downloadExcelTitle == null) {
            downloadOrder.setTitle(field.getName());
            downloadOrder.setOrder(0);
        } else {
            String title = downloadExcelTitle.title();
            if (StringUtils.isEmpty((CharSequence)title)) {
                title = field.getName();
            }
            int order = downloadExcelTitle.order();
            downloadOrder.setTitle(title);
            downloadOrder.setOrder(order);
        }
        return downloadOrder;
    }

    private static <E> void checkParams(List<E> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            log.error("The entity list is empty!");
            throw new ExcelHandlerException("The entity list must not be empty!");
        }
    }
}

