/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.UploadConvert;
import top.lshaci.framework.excel.annotation.UploadExcelTitle;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.model.ExcelRelationModel;
import top.lshaci.framework.utils.DateUtils;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.ReflectionUtils;
import top.lshaci.framework.utils.StringConverterUtils;
import top.lshaci.framework.utils.enums.FileType;

public abstract class POIExcelUploadHandler {
    private static final Logger log = LoggerFactory.getLogger(POIExcelUploadHandler.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> List<E> excel2Entities(File excelFile, Class<E> entityClass) {
        POIExcelUploadHandler.checkParams(excelFile, entityClass);
        FileType fileType = POIExcelUploadHandler.getFileType(excelFile);
        Map<String, ExcelRelationModel> relations = POIExcelUploadHandler.handlerRelations(entityClass);
        try (Workbook workBook = POIExcelUploadHandler.getWorkBook(excelFile, fileType);){
            int sheets = workBook.getNumberOfSheets();
            ArrayList<E> result = new ArrayList<E>();
            for (int i = 0; i < sheets; ++i) {
                String[] titles;
                List<E> rowDatas;
                int lastRowNum;
                Sheet sheet = workBook.getSheetAt(i);
                if (sheet == null || (lastRowNum = sheet.getLastRowNum()) < 1 || CollectionUtils.isEmpty(rowDatas = POIExcelUploadHandler.getRowDatas(sheet, lastRowNum, (titles = POIExcelUploadHandler.getTitles(sheet)).length, titles, entityClass, relations))) continue;
                result.addAll(rowDatas);
            }
            ArrayList<E> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            log.error("Parse excel error", (Throwable)e);
            throw new ExcelHandlerException("Convert excel file to entity list is error!", e);
        }
    }

    private static <E> List<E> getRowDatas(Sheet sheet, int lastRowNum, int rowLength, String[] titles, Class<E> entityClass, Map<String, ExcelRelationModel> relations) {
        ArrayList<Object> rowDatas = new ArrayList<Object>();
        for (int i = 1; i <= lastRowNum; ++i) {
            Row row = sheet.getRow(i);
            Object entity = ReflectionUtils.newInstance(entityClass);
            if (entity == null) {
                String msg = "New instance is error!";
                log.error(msg);
                throw new ExcelHandlerException(msg);
            }
            for (Cell cell : row) {
                Field field;
                String title;
                ExcelRelationModel relationModel;
                if (cell == null) continue;
                int columnIndex = cell.getColumnIndex();
                String cellValue = POIExcelUploadHandler.getCellValue(cell);
                if (StringUtils.isEmpty((CharSequence)cellValue) || (relationModel = relations.get(title = titles[columnIndex])) == null || (field = relationModel.getTargetField()) == null) continue;
                cellValue = POIExcelUploadHandler.getConvertValue(cellValue, relationModel);
                POIExcelUploadHandler.setEntityFieldValue(entity, field, cellValue);
            }
            rowDatas.add(entity);
        }
        return rowDatas;
    }

    private static String getConvertValue(String cellValue, ExcelRelationModel relationModel) {
        Method method = relationModel.getConvertMethod();
        if (method != null) {
            Object instance = relationModel.getConvertInstance();
            Object value = ReflectionUtils.invokeMethod((Object)instance, (Method)method, (Object[])new Object[]{cellValue});
            return value == null ? null : value.toString();
        }
        return cellValue;
    }

    private static <E> void setEntityFieldValue(E entity, Field field, String cellValue) {
        try {
            Object targetValue = StringConverterUtils.getTargetValue(field.getType(), (String)cellValue);
            ReflectionUtils.setFieldValue(entity, (Field)field, (Object)targetValue);
        }
        catch (SecurityException e) {
            log.warn("The field(" + field.getName() + ") is not has security!", (Throwable)e);
        }
    }

    private static String getCellValue(Cell cell) {
        if (CellType.NUMERIC.equals((Object)cell.getCellTypeEnum())) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                return DateUtils.formatLongDate((Date)cell.getDateCellValue());
            }
            cell.setCellType(CellType.STRING);
        }
        if (CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
            return cell.getStringCellValue();
        }
        return null;
    }

    private static String[] getTitles(Sheet sheet) {
        Row row = sheet.getRow(0);
        int lastCellNum = row.getLastCellNum();
        if (lastCellNum < 0) {
            throw new ExcelHandlerException("This excel sheet's title row not has cell!");
        }
        String[] titles = new String[lastCellNum];
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            titles[i] = cell.getStringCellValue().trim();
        }
        return titles;
    }

    private static Workbook getWorkBook(File excelFile, FileType fileType) {
        XSSFWorkbook workbook = null;
        try {
            FileInputStream is = new FileInputStream(excelFile);
            if (FileType.XLSX_DOCX.equals((Object)fileType)) {
                workbook = new XSSFWorkbook((InputStream)is);
            }
            if (FileType.XLS_DOC.equals((Object)fileType)) {
                workbook = new HSSFWorkbook((InputStream)is);
            }
        }
        catch (IOException e) {
            log.error("Create excle work book is error!", (Throwable)e);
            throw new ExcelHandlerException("Create excle work book is error!");
        }
        Objects.requireNonNull(workbook, "The excle work book is must not be null!");
        return workbook;
    }

    private static FileType getFileType(File excelFile) {
        Objects.requireNonNull(excelFile, "The excel file is must not be null!");
        try {
            FileType fileType = FileTypeUtil.getType((File)excelFile);
            if (FileType.XLSX_DOCX.equals((Object)fileType) || FileType.XLS_DOC.equals((Object)fileType)) {
                return fileType;
            }
            throw new ExcelHandlerException("The file is not excel!");
        }
        catch (IOException e) {
            log.error("Get file header has error!", (Throwable)e);
            throw new ExcelHandlerException("Get file header has error!");
        }
    }

    private static <E> Map<String, ExcelRelationModel> handlerRelations(Class<E> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("The entity not has any field!");
        }
        HashMap convertClassCache = new HashMap();
        return Arrays.stream(fields).collect(Collectors.toMap(f -> POIExcelUploadHandler.getFieldTitleName(f), f -> POIExcelUploadHandler.createExcelRelationModel(f, convertClassCache)));
    }

    private static String getFieldTitleName(Field field) {
        UploadExcelTitle excelTitle = field.getAnnotation(UploadExcelTitle.class);
        if (excelTitle != null) {
            return excelTitle.value();
        }
        return field.getName();
    }

    private static Object getConvertInstance(Map<Class<?>, Object> convertClassCache, UploadConvert convert) {
        Class<?> convertClass = convert.clazz();
        if (convertClass == null) {
            throw new ExcelHandlerException("The convert class must not be null!");
        }
        Object convertInstance = convertClassCache.get(convertClass);
        if (convertInstance == null) {
            convertInstance = ReflectionUtils.newInstance(convertClass);
            convertClassCache.put(convertClass, convertInstance);
        }
        return convertInstance;
    }

    private static Method getConvertMethod(UploadConvert convert) {
        String methodName = convert.method();
        Class<?> convertClass = convert.clazz();
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new ExcelHandlerException("The convert method name must not be empty!");
        }
        try {
            return convertClass.getDeclaredMethod(methodName, String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "Get the convert method is error!";
            log.error(msg, (Throwable)e);
            throw new ExcelHandlerException(msg);
        }
    }

    private static ExcelRelationModel createExcelRelationModel(Field field, Map<Class<?>, Object> convertClassCache) {
        ExcelRelationModel model = new ExcelRelationModel(field);
        UploadConvert convert = field.getAnnotation(UploadConvert.class);
        if (convert != null) {
            Object convertInstance = POIExcelUploadHandler.getConvertInstance(convertClassCache, convert);
            Method convertMethod = POIExcelUploadHandler.getConvertMethod(convert);
            model.setConvertInstance(convertInstance);
            model.setConvertMethod(convertMethod);
        }
        return model;
    }

    private static <E> void checkParams(File excelFile, Class<E> entityClass) {
        Objects.requireNonNull(excelFile, "The excel file must not be null!");
        Objects.requireNonNull(entityClass, "The entity class must not be null!");
    }
}

