/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.UploadConvert;
import top.lshaci.framework.excel.annotation.UploadExcelTitle;
import top.lshaci.framework.excel.annotation.UploadVerify;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.handler.POIExcelBaseHandler;
import top.lshaci.framework.excel.model.ExcelRelationModel;
import top.lshaci.framework.utils.DateUtils;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.ReflectionUtils;
import top.lshaci.framework.utils.StreamUtils;
import top.lshaci.framework.utils.StringConverterUtils;
import top.lshaci.framework.utils.enums.FileType;

public abstract class POIExcelUploadHandler {
    private static final Logger log = LoggerFactory.getLogger(POIExcelUploadHandler.class);
    private static final List<FileType> ALLOW_FILE_TYPES = Arrays.asList(FileType.XLSX_DOCX, FileType.XLS_DOC, FileType.WPS, FileType.WPSX);
    private static final List<String> ALLOW_FILE_SUFFIX = Arrays.asList("xls", "xlsx");

    public static <E> List<E> excel2Entities(File excelFile, Class<E> entityClass) throws ExcelHandlerException {
        return POIExcelUploadHandler.excel2Entities(excelFile, 0, entityClass);
    }

    public static <E> List<E> excel2Entities(File excelFile, int titleRow, Class<E> entityClass) throws ExcelHandlerException {
        POIExcelUploadHandler.checkParams(titleRow, excelFile, entityClass);
        FileType fileType = POIExcelUploadHandler.getFileType(excelFile);
        Workbook workBook = POIExcelUploadHandler.getWorkBook(excelFile, fileType);
        return POIExcelUploadHandler.workBook2Entities(workBook, titleRow, entityClass);
    }

    public static <E> List<E> excel2Entities(InputStream is, Class<E> entityClass) throws ExcelHandlerException {
        return POIExcelUploadHandler.excel2Entities(is, 0, entityClass);
    }

    public static <E> List<E> excel2Entities(InputStream is, int titleRow, Class<E> entityClass) throws ExcelHandlerException {
        POIExcelUploadHandler.checkParams(titleRow, is, entityClass);
        ByteArrayOutputStream buffer = StreamUtils.copyInputStream((InputStream)is);
        FileType fileType = POIExcelUploadHandler.getFileType(new ByteArrayInputStream(buffer.toByteArray()));
        Workbook workBook = POIExcelUploadHandler.getWorkBook(new ByteArrayInputStream(buffer.toByteArray()), fileType);
        return POIExcelUploadHandler.workBook2Entities(workBook, titleRow, entityClass);
    }

    private static <E> List<E> workBook2Entities(Workbook workBook, int titleRow, Class<E> entityClass) {
        Map<String[], ExcelRelationModel> relations = POIExcelUploadHandler.handlerRelations(entityClass);
        int sheets = workBook.getNumberOfSheets();
        ArrayList<E> result = new ArrayList<E>();
        for (int i = 0; i < sheets; ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            if (sheet == null) continue;
            int lastRowNum = sheet.getLastRowNum();
            if (lastRowNum <= titleRow) {
                log.warn("The sheet last row number is {}.", (Object)lastRowNum);
                continue;
            }
            String[] titles = POIExcelUploadHandler.getTitles(sheet, titleRow);
            POIExcelUploadHandler.verifyTitle(relations.keySet(), titles, entityClass);
            List<E> rowDatas = POIExcelUploadHandler.getRowDatas(sheet, titleRow, lastRowNum, titles, entityClass, relations);
            if (CollectionUtils.isEmpty(rowDatas)) continue;
            result.addAll(rowDatas);
        }
        return result;
    }

    private static <E> void verifyTitle(Set<String[]> fieldTitles, String[] excelTitles, Class<E> entityClass) {
        UploadVerify uploadVerify = entityClass.getAnnotation(UploadVerify.class);
        if (uploadVerify != null && uploadVerify.verifyTitleLength()) {
            Set fieldTitleSet = fieldTitles.stream().flatMap(Arrays::stream).collect(Collectors.toSet());
            Set excelTitleSet = Arrays.stream(excelTitles).collect(Collectors.toSet());
            fieldTitleSet.retainAll(excelTitleSet);
            if (CollectionUtils.isEmpty(fieldTitleSet) || fieldTitleSet.size() != excelTitleSet.size()) {
                throw new ExcelHandlerException("Excel\u6587\u4ef6\u672a\u4f7f\u7528\u6b63\u786e\u7684\u6a21\u677f");
            }
        }
    }

    private static <E> List<E> getRowDatas(Sheet sheet, int titleRow, int lastRowNum, String[] titles, Class<E> entityClass, Map<String[], ExcelRelationModel> relations) {
        ArrayList<E> rowDatas = new ArrayList<E>();
        UploadVerify uploadVerify = entityClass.getAnnotation(UploadVerify.class);
        boolean requireCellValue = uploadVerify != null && uploadVerify.requireCellValue();
        boolean requireRowValue = uploadVerify != null && uploadVerify.requireRowValue();
        for (int i = titleRow + 1; i <= lastRowNum; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                log.warn("The row[{}] is null!", (Object)(i + 1));
                if (!requireRowValue) continue;
                throw new ExcelHandlerException("\u8868\u683c\u4e2d, \u884c[" + (i + 1) + "]\u4e3a\u7a7a");
            }
            HashSet<Object> targetValues = new HashSet<Object>();
            Map<String, String> cellValueMap = POIExcelUploadHandler.getCellValues(titles, row, requireCellValue);
            if (cellValueMap.isEmpty()) continue;
            E entity = POIExcelUploadHandler.createEntity(entityClass, relations, targetValues, cellValueMap);
            if (!CollectionUtils.isNotEmpty(targetValues)) continue;
            rowDatas.add(entity);
        }
        return rowDatas;
    }

    private static <E> E createEntity(Class<E> entityClass, Map<String[], ExcelRelationModel> relations, Set<Object> targetValues, Map<String, String> cellValueMap) {
        Object entity = ReflectionUtils.newInstance(entityClass);
        if (entity == null) {
            log.error("New instance is error! {}", (Object)entityClass.getSimpleName());
            throw new ExcelHandlerException("\u521b\u5efa\u4e0a\u4f20\u5bf9\u8c61\u51fa\u9519");
        }
        relations.forEach((titleArray, relationModel) -> {
            Object[] cellValues = Arrays.stream(titleArray).map(t -> (String)cellValueMap.get(t)).collect(Collectors.toList()).toArray(new Object[((String[])titleArray).length]);
            Object targetValue = POIExcelUploadHandler.verifyTargetValue(titleArray, relationModel, cellValues);
            if (targetValue != null) {
                targetValues.add(targetValue);
                ReflectionUtils.setFieldValue((Object)entity, (Field)relationModel.getTargetField(), (Object)targetValue);
            }
        });
        return (E)entity;
    }

    private static Map<String, String> getCellValues(String[] titles, Row row, boolean requireCellValue) {
        HashMap<String, String> cellValueMap = new HashMap<String, String>();
        for (int j = 0; j < titles.length; ++j) {
            Cell cell = row.getCell(j);
            if (cell == null) {
                log.warn("The cell is null! row:{} column:{}", (Object)(row.getRowNum() + 1), (Object)(j + 1));
                if (!requireCellValue) continue;
                throw new ExcelHandlerException("\u5355\u5143\u683c\u4e3a\u7a7a! \u884c:" + (row.getRowNum() + 1) + " \u5217:" + (j + 1));
            }
            int columnIndex = cell.getColumnIndex();
            String cellValue = POIExcelUploadHandler.getCellValue(cell);
            if (StringUtils.isEmpty((CharSequence)cellValue)) continue;
            String title = titles[columnIndex];
            cellValueMap.put(title, cellValue);
        }
        return cellValueMap;
    }

    private static Object verifyTargetValue(String[] titleArray, ExcelRelationModel relationModel, Object[] cellValues) {
        Object targetValue = POIExcelUploadHandler.getTargetValue(relationModel, cellValues);
        if (relationModel.isRequire() && targetValue == null) {
            String titles = Arrays.toString(titleArray);
            throw new ExcelHandlerException(titles + "\u89e3\u6790\u4e3a\u7a7a");
        }
        return targetValue;
    }

    private static Object getTargetValue(ExcelRelationModel relationModel, Object ... cellValues) {
        if (ArrayUtils.isEmpty((Object[])cellValues)) {
            return null;
        }
        Method method = relationModel.getConvertMethod();
        if (method != null) {
            return POIExcelUploadHandler.getConvertValue(relationModel, cellValues);
        }
        Object value = cellValues[0];
        if (value == null) {
            return null;
        }
        try {
            return StringConverterUtils.getTargetValue(relationModel.getTargetField().getType(), (String)value.toString());
        }
        catch (Exception e) {
            log.warn("StringConverterUtils converter value is error!", (Throwable)e);
            return null;
        }
    }

    private static Object getConvertValue(ExcelRelationModel relationModel, Object ... cellValues) {
        try {
            return ReflectionUtils.invokeMethod((Object)relationModel.getConvertInstance(), (Method)relationModel.getConvertMethod(), (Object[])cellValues);
        }
        catch (Exception e) {
            log.error("Get convert value error! The field is: " + relationModel.getTargetField().getName(), (Throwable)e);
            return null;
        }
    }

    private static String getCellValue(Cell cell) {
        if (CellType.NUMERIC.equals((Object)cell.getCellTypeEnum())) {
            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                return DateUtils.formatLongDate((Date)cell.getDateCellValue());
            }
            cell.setCellType(CellType.STRING);
        }
        if (CellType.STRING.equals((Object)cell.getCellTypeEnum())) {
            return cell.getStringCellValue();
        }
        return null;
    }

    private static String[] getTitles(Sheet sheet, int titleRow) {
        Row row = sheet.getRow(titleRow < 0 ? 0 : titleRow);
        int lastCellNum = row.getLastCellNum();
        if (lastCellNum < 0) {
            throw new ExcelHandlerException("\u8be5Excel\u4e2d\u65e0\u6807\u9898\u884c");
        }
        String[] titles = new String[lastCellNum];
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            cell.setCellType(CellType.STRING);
            titles[i] = cell.getStringCellValue().trim();
        }
        return titles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Workbook getWorkBook(File excelFile, FileType fileType) {
        try (FileInputStream is = new FileInputStream(excelFile);){
            Workbook workbook = POIExcelUploadHandler.getWorkBook(is, fileType);
            return workbook;
        }
        catch (Exception e) {
            log.error("Create excel work book is error!", (Throwable)e);
            throw new ExcelHandlerException("\u83b7\u53d6Excel\u5de5\u4f5c\u7c3f\u51fa\u9519");
        }
    }

    private static Workbook getWorkBook(InputStream is, FileType fileType) {
        XSSFWorkbook workbook = null;
        try {
            if (FileType.XLSX_DOCX.equals((Object)fileType) || FileType.WPSX.equals((Object)fileType)) {
                workbook = new XSSFWorkbook(is);
            }
            if (FileType.XLS_DOC.equals((Object)fileType) || FileType.WPS.equals((Object)fileType)) {
                workbook = new HSSFWorkbook(is);
            }
        }
        catch (Exception e) {
            log.error("Create excel work book is error!", (Throwable)e);
            throw new ExcelHandlerException("\u83b7\u53d6Excel\u5de5\u4f5c\u7c3f\u51fa\u9519");
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn("Close excel file input stream error, ignore this exception!");
            }
        }
        if (workbook == null) {
            throw new ExcelHandlerException("\u672a\u83b7\u53d6\u5230Excel\u5de5\u4f5c\u7c3f");
        }
        return workbook;
    }

    private static FileType getFileType(InputStream is) {
        FileType fileType = FileTypeUtil.getType((InputStream)is);
        if (ALLOW_FILE_TYPES.contains(fileType)) {
            return fileType;
        }
        throw new ExcelHandlerException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u662fExcel\u683c\u5f0f");
    }

    private static FileType getFileType(File excelFile) {
        String fileName = excelFile.getName();
        String fileSuffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        if (!ALLOW_FILE_SUFFIX.contains(fileSuffix)) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u662fExcel\u683c\u5f0f");
        }
        FileType fileType = FileTypeUtil.getType((File)excelFile);
        if (ALLOW_FILE_TYPES.contains(fileType)) {
            return fileType;
        }
        throw new ExcelHandlerException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u662fExcel\u683c\u5f0f");
    }

    private static <E> Map<String[], ExcelRelationModel> handlerRelations(Class<E> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u5bf9\u8c61\u4e2d\u672a\u5b9a\u4e49\u5b57\u6bb5");
        }
        HashMap convertClassCache = new HashMap();
        Map<String[], ExcelRelationModel> relations = Arrays.stream(fields).filter(f -> f.getAnnotation(UploadExcelTitle.class) != null).collect(Collectors.toMap(f -> POIExcelUploadHandler.getFieldTitleName(f), f -> POIExcelUploadHandler.createExcelRelationModel(f, convertClassCache)));
        if (MapUtils.isEmpty(relations)) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u5bf9\u8c61\u4e2d\u672a\u6807\u8bb0\u9700\u8981\u7684\u5b57\u6bb5");
        }
        return relations;
    }

    private static String[] getFieldTitleName(Field field) {
        UploadExcelTitle excelTitle = field.getAnnotation(UploadExcelTitle.class);
        return excelTitle.value();
    }

    private static Method getConvertMethod(UploadConvert convert, int argSize) {
        String methodName = convert.method();
        Class<?> convertClass = convert.clazz();
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new ExcelHandlerException("\u76ee\u6807\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5\u540d\u4e3a\u7a7a");
        }
        try {
            Class[] args = new Class[argSize];
            for (int i = 0; i < argSize; ++i) {
                args[i] = String.class;
            }
            return convertClass.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "Get the convert method is error!";
            log.error(msg, (Throwable)e);
            throw new ExcelHandlerException("\u83b7\u53d6\u76ee\u6807\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5\u9519\u8bef");
        }
    }

    private static ExcelRelationModel createExcelRelationModel(Field field, Map<Class<?>, Object> convertClassCache) {
        ExcelRelationModel model = new ExcelRelationModel(field);
        UploadConvert convert = field.getAnnotation(UploadConvert.class);
        UploadExcelTitle uploadExcelTitle = field.getAnnotation(UploadExcelTitle.class);
        model.setRequire(uploadExcelTitle.require());
        if (convert != null) {
            int argSize = 1;
            if (uploadExcelTitle != null) {
                argSize = uploadExcelTitle.value().length;
            }
            Object convertInstance = POIExcelBaseHandler.getConvertInstance(convertClassCache, convert.clazz());
            Method convertMethod = POIExcelUploadHandler.getConvertMethod(convert, argSize);
            model.setConvertInstance(convertInstance);
            model.setConvertMethod(convertMethod);
        }
        return model;
    }

    private static <E> void checkParams(int titleRow, File excelFile, Class<E> entityClass) {
        POIExcelUploadHandler.checkParams(titleRow, entityClass);
        if (excelFile == null) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a");
        }
    }

    private static <E> void checkParams(int titleRow, InputStream is, Class<E> entityClass) {
        POIExcelUploadHandler.checkParams(titleRow, entityClass);
        if (is == null) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41\u4e3a\u7a7a");
        }
    }

    private static <E> void checkParams(int titleRow, Class<E> entityClass) {
        if (titleRow < 0) {
            throw new ExcelHandlerException("\u6807\u9898\u884c\u5c0f\u4e8e0");
        }
        if (entityClass == null) {
            throw new ExcelHandlerException("\u4e0a\u4f20\u5bf9\u8c61\u7c7b\u578b\u4e3a\u7a7a");
        }
    }
}

