/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handler;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.DownloadAllField;
import top.lshaci.framework.excel.annotation.DownloadConvert;
import top.lshaci.framework.excel.annotation.DownloadExcelFirstTitle;
import top.lshaci.framework.excel.annotation.DownloadExcelSheet;
import top.lshaci.framework.excel.annotation.DownloadExcelTitle;
import top.lshaci.framework.excel.annotation.DownloadIgnore;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.handler.POIExcelBaseHandler;
import top.lshaci.framework.excel.model.DownloadOrder;
import top.lshaci.framework.excel.model.ExcelRelationModel;
import top.lshaci.framework.utils.ReflectionUtils;

public abstract class POIExcelDownloadHandler {
    private static final Logger log = LoggerFactory.getLogger(POIExcelDownloadHandler.class);
    private static final ThreadLocal<Integer> CURRENT_ROW_NUMBER = new ThreadLocal();
    private static final ThreadLocal<String> FONT_NAME = new ThreadLocal();
    private static final String DEFAULT_FONT_NAME = "\u5b8b\u4f53";

    public static <E> ByteArrayOutputStream entities2Excel(List<E> entities) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        POIExcelDownloadHandler.entities2Excel(entities, os);
        return os;
    }

    public static <E> void entities2Excel(List<E> entities, OutputStream os) {
        POIExcelDownloadHandler.checkParams(entities);
        Class<?> entityClass = entities.get(0).getClass();
        List<DownloadOrder> titleOrders = POIExcelDownloadHandler.getTitleOrder(entityClass);
        List<String[]> rowDatas = POIExcelDownloadHandler.entities2StringArrays(entities, titleOrders, entityClass);
        try (OutputStream os_ = os;
             XSSFWorkbook workbook = new XSSFWorkbook();){
            String sheetName = POIExcelDownloadHandler.getSheetName(entityClass);
            XSSFSheet sheet = workbook.createSheet(sheetName);
            POIExcelDownloadHandler.setColumnWidth(titleOrders, sheet);
            CURRENT_ROW_NUMBER.set(0);
            POIExcelDownloadHandler.setFirstTitle(workbook, sheet, entityClass, titleOrders.size());
            POIExcelDownloadHandler.setColumnTitles(workbook, sheet, titleOrders);
            POIExcelDownloadHandler.setSheetRows(workbook, sheet, rowDatas);
            workbook.write(os_);
        }
        catch (Exception e) {
            log.error("Parse entity list error", (Throwable)e);
            throw new ExcelHandlerException("Convert entity list to excel file is error!", e);
        }
    }

    private static void setColumnWidth(List<DownloadOrder> titleOrder, XSSFSheet sheet) {
        sheet.setDefaultColumnWidth(12);
        sheet.setColumnWidth(0, 1500);
        for (int i = 0; i < titleOrder.size(); ++i) {
            DownloadOrder downloadOrder = titleOrder.get(i);
            int columnWidth = downloadOrder.getColumnWidth();
            sheet.setColumnWidth(i + 1, columnWidth <= 0 ? 3072 : columnWidth * 256);
        }
    }

    private static void setSheetRows(XSSFWorkbook workbook, XSSFSheet sheet, List<String[]> rowDatas) {
        int currentRowNumber = CURRENT_ROW_NUMBER.get();
        XSSFCellStyle contentStyle = POIExcelDownloadHandler.createContentStyle(workbook);
        for (int i = 0; i < rowDatas.size(); ++i) {
            XSSFRow row = sheet.createRow(currentRowNumber++);
            row.setHeight((short)320);
            String[] rowData = rowDatas.get(i);
            for (int j = 0; j <= rowData.length; ++j) {
                XSSFCell cell = row.createCell(j);
                String value = j == 0 ? i + 1 + "" : rowData[j - 1];
                cell.setCellValue(value);
                cell.setCellStyle((CellStyle)contentStyle);
            }
            CURRENT_ROW_NUMBER.set(currentRowNumber);
        }
    }

    private static XSSFCellStyle createContentStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.WHITE));
        POIExcelDownloadHandler.setBorder(style);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)10);
        font.setFontName(FONT_NAME.get());
        style.setFont((Font)font);
        return style;
    }

    private static void setFirstTitle(XSSFWorkbook workbook, XSSFSheet sheet, Class<?> entityClass, int size) {
        DownloadExcelFirstTitle firstTitle = entityClass.getAnnotation(DownloadExcelFirstTitle.class);
        if (firstTitle != null) {
            String firstTitleName = firstTitle.name();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{firstTitleName})) {
                int currentRowNumber = CURRENT_ROW_NUMBER.get();
                XSSFRow row = sheet.createRow(currentRowNumber++);
                row.setHeight(firstTitle.height());
                CellRangeAddress region = new CellRangeAddress(0, 0, 0, size);
                sheet.addMergedRegion(region);
                XSSFCell cell = row.createCell(0);
                cell.setCellValue(firstTitleName);
                cell.setCellStyle((CellStyle)POIExcelDownloadHandler.createFirstTitleStyle(workbook));
                POIExcelDownloadHandler.setMergeCellBorder(region, sheet);
                CURRENT_ROW_NUMBER.set(currentRowNumber);
            }
        }
    }

    private static void setMergeCellBorder(CellRangeAddress region, XSSFSheet sheet) {
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
    }

    private static XSSFCellStyle createFirstTitleStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        style.setFillForegroundColor(new XSSFColor(Color.WHITE));
        POIExcelDownloadHandler.setBorder(style);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)20);
        font.setBold(true);
        font.setFontName(FONT_NAME.get());
        style.setFont((Font)font);
        return style;
    }

    private static void setColumnTitles(XSSFWorkbook workbook, XSSFSheet sheet, List<DownloadOrder> titleOrder) {
        int currentRowNumber = CURRENT_ROW_NUMBER.get();
        XSSFRow row = sheet.createRow(currentRowNumber++);
        row.setHeight((short)360);
        XSSFCellStyle columnTitleStyle = POIExcelDownloadHandler.createColumnTitleStyle(workbook);
        for (int i = 0; i <= titleOrder.size(); ++i) {
            XSSFCell cell = row.createCell(i);
            String value = i == 0 ? "\u5e8f\u53f7" : titleOrder.get(i - 1).getTitle();
            cell.setCellValue(value);
            cell.setCellStyle((CellStyle)columnTitleStyle);
        }
        CURRENT_ROW_NUMBER.set(currentRowNumber);
    }

    private static XSSFCellStyle createColumnTitleStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.WHITE));
        POIExcelDownloadHandler.setBorder(style);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        font.setFontName(FONT_NAME.get());
        style.setFont((Font)font);
        return style;
    }

    private static void setBorder(XSSFCellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private static String getSheetName(Class<?> entityClass) {
        DownloadExcelSheet downloadExcelSheet = entityClass.getAnnotation(DownloadExcelSheet.class);
        String sheetName = entityClass.getSimpleName();
        if (downloadExcelSheet != null) {
            sheetName = downloadExcelSheet.sheetName();
            String fontName = downloadExcelSheet.fontName();
            fontName = StringUtils.isNotBlank((CharSequence)fontName) ? fontName.trim() : DEFAULT_FONT_NAME;
            FONT_NAME.set(fontName);
            sheetName = StringUtils.isNotBlank((CharSequence)sheetName) ? sheetName.trim() : entityClass.getSimpleName();
        }
        return sheetName;
    }

    private static <E> List<String[]> entities2StringArrays(List<E> entities, List<DownloadOrder> titleOrder, Class<?> entityClass) {
        Map<String, ExcelRelationModel> handlerRelations = POIExcelDownloadHandler.handlerRelations(entityClass);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (E entity : entities) {
            int length = titleOrder.size();
            String[] row = new String[length];
            for (int i = 0; i < length; ++i) {
                DownloadOrder downloadOrder = titleOrder.get(i);
                Field field = downloadOrder.getField();
                String title = downloadOrder.getTitle();
                Object value = ReflectionUtils.getFieldValue(entity, (Field)field);
                ExcelRelationModel relationModel = handlerRelations.get(title);
                if (relationModel != null) {
                    value = POIExcelDownloadHandler.getConvertValue(value, relationModel);
                }
                row[i] = value != null ? value.toString() : "";
            }
            rows.add(row);
        }
        if (CollectionUtils.isEmpty(rows)) {
            log.error("The content is empty!");
            throw new ExcelHandlerException("\u5bfc\u51fa\u5bf9\u8c61\u89e3\u6790\u5185\u5bb9\u4e3a\u7a7a");
        }
        return rows;
    }

    private static Object getConvertValue(Object value, ExcelRelationModel relationModel) {
        Method method = relationModel.getConvertMethod();
        if (method != null) {
            Object instance = relationModel.getConvertInstance();
            Object convertValue = ReflectionUtils.invokeMethod((Object)instance, (Method)method, (Object[])new Object[]{value});
            return convertValue == null ? "" : convertValue.toString();
        }
        return value;
    }

    private static <E> Map<String, ExcelRelationModel> handlerRelations(Class<E> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("\u5bfc\u51fa\u5bf9\u8c61\u4e2d\u672a\u5b9a\u4e49\u5b57\u6bb5");
        }
        HashMap convertClassCache = new HashMap();
        boolean downloadAllField = entityClass.getAnnotation(DownloadAllField.class) != null;
        return Arrays.stream(fields).filter(f -> f.getAnnotation(DownloadIgnore.class) == null).filter(f -> downloadAllField || f.getAnnotation(DownloadExcelTitle.class) != null).collect(Collectors.toMap(POIExcelDownloadHandler::getFieldTitleName, f -> POIExcelDownloadHandler.createExcelRelationModel(f, convertClassCache)));
    }

    private static String getFieldTitleName(Field field) {
        DownloadExcelTitle excelTitle = field.getAnnotation(DownloadExcelTitle.class);
        if (excelTitle != null) {
            return excelTitle.title();
        }
        return field.getName();
    }

    private static ExcelRelationModel createExcelRelationModel(Field field, Map<Class<?>, Object> convertClassCache) {
        ExcelRelationModel model = new ExcelRelationModel(field);
        DownloadConvert convert = field.getAnnotation(DownloadConvert.class);
        if (convert != null) {
            Object convertInstance = POIExcelBaseHandler.getConvertInstance(convertClassCache, convert.clazz());
            Method convertMethod = POIExcelDownloadHandler.getConvertMethod(convert, field.getType());
            model.setConvertInstance(convertInstance);
            model.setConvertMethod(convertMethod);
        }
        return model;
    }

    private static Method getConvertMethod(DownloadConvert convert, Class<?> clazz) {
        String methodName = convert.method();
        Class<?> convertClass = convert.clazz();
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new ExcelHandlerException("\u76ee\u6807\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5\u540d\u4e3a\u7a7a");
        }
        try {
            return convertClass.getDeclaredMethod(methodName, clazz);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = "Get the convert method is error!";
            log.error(msg, (Throwable)e);
            throw new ExcelHandlerException("\u83b7\u53d6\u76ee\u6807\u7c7b\u578b\u8f6c\u6362\u65b9\u6cd5\u9519\u8bef");
        }
    }

    private static List<DownloadOrder> getTitleOrder(Class<?> entityClass) {
        Object[] fields = entityClass.getDeclaredFields();
        if (ArrayUtils.isEmpty((Object[])fields)) {
            throw new ExcelHandlerException("\u5bfc\u51fa\u5bf9\u8c61\u4e2d\u672a\u5b9a\u4e49\u5b57\u6bb5");
        }
        boolean downloadAllField = entityClass.getAnnotation(DownloadAllField.class) != null;
        List<DownloadOrder> titleOrders = Arrays.stream(fields).filter(f -> f.getAnnotation(DownloadIgnore.class) == null).filter(f -> downloadAllField || f.getAnnotation(DownloadExcelTitle.class) != null).map(f -> POIExcelDownloadHandler.createDownloadOrder(f)).sorted().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(titleOrders)) {
            log.error("The excel title is empty!");
            throw new ExcelHandlerException("\u5bfc\u51fa\u5bf9\u8c61\u4e2d\u672a\u6807\u8bb0\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5");
        }
        return titleOrders;
    }

    private static DownloadOrder createDownloadOrder(Field field) {
        DownloadExcelTitle downloadExcelTitle = field.getAnnotation(DownloadExcelTitle.class);
        DownloadOrder downloadOrder = new DownloadOrder(field);
        if (downloadExcelTitle != null) {
            String title = downloadExcelTitle.title();
            if (StringUtils.isBlank((CharSequence)title)) {
                title = field.getName();
            }
            int order = downloadExcelTitle.order();
            int columnWidth = downloadExcelTitle.columnWidth();
            downloadOrder.setTitle(title);
            downloadOrder.setOrder(order);
            downloadOrder.setColumnWidth(columnWidth);
        } else {
            downloadOrder.setTitle(field.getName());
            downloadOrder.setOrder(0);
        }
        return downloadOrder;
    }

    private static <E> void checkParams(List<E> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            log.error("The entity list is empty!");
            throw new ExcelHandlerException("\u65e0\u6570\u636e\u53ef\u5bfc\u51fa");
        }
    }
}

