/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.builder.impl;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import top.lshaci.framework.excel.builder.CellStyleBuilder;
import top.lshaci.framework.excel.entity.ExportSheetParam;

public class DefaultCellStyleBuilder
implements CellStyleBuilder {
    @Override
    public void setMergeCellBorder(CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
    }

    @Override
    public CellStyle contentStyle(Workbook workbook, ExportSheetParam exportSheetParam) {
        CellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK.index, (short)10, false, exportSheetParam.getFontName());
        style.setFont(font);
        return style;
    }

    @Override
    public CellStyle sheetTitleStyle(Workbook workbook, ExportSheetParam exportSheetParam) {
        CellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK.index, (short)20, true, exportSheetParam.getFontName());
        style.setFont(font);
        return style;
    }

    @Override
    public CellStyle columnTitleStyle(Workbook workbook, ExportSheetParam exportSheetParam) {
        CellStyle style = workbook.createCellStyle();
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK.index, (short)12, true, exportSheetParam.getFontName());
        style.setFont(font);
        return style;
    }

    private Font createFont(Workbook workbook, short color, short height, Boolean bold, String fontName) {
        Font font = workbook.createFont();
        font.setColor(color);
        font.setFontHeightInPoints(height);
        font.setBold(bold.booleanValue());
        font.setFontName(fontName);
        return font;
    }

    private void setCenter(CellStyle style) {
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
    }

    private void setBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }
}

