/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.entity;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import top.lshaci.framework.excel.annotation.ImportTitle;
import top.lshaci.framework.excel.entity.BaseTitleParam;

public class ImportTitleParam
extends BaseTitleParam
implements Comparable<ImportTitleParam> {
    private int colNum;
    private boolean required;

    public ImportTitleParam(Field field, Class<?> cls) {
        this.field = field;
        this.title = field.getName();
        this.method = this.createByField(field, cls, BaseTitleParam.MethodType.SET, field.getType());
        ImportTitle importTitle = field.getAnnotation(ImportTitle.class);
        if (Objects.isNull(importTitle)) {
            return;
        }
        this.build(importTitle);
        this.buildConvertMethod(importTitle.convertClass(), importTitle.convertMethod(), String.class);
    }

    private void build(ImportTitle importTitle) {
        this.required = importTitle.required();
        if (StringUtils.isNotBlank((CharSequence)importTitle.prefix())) {
            this.prefix = importTitle.prefix();
        }
        if (StringUtils.isNotBlank((CharSequence)importTitle.suffix())) {
            this.suffix = importTitle.suffix();
        }
        if (StringUtils.isNotBlank((CharSequence)importTitle.title())) {
            this.title = importTitle.title();
        }
        if (ArrayUtils.isNotEmpty((Object[])importTitle.replaces())) {
            this.replaceMap = Arrays.stream(importTitle.replaces()).filter(r -> r.contains("__")).map(r -> r.split("__")).filter(a -> ((String[])a).length > 1).collect(Collectors.toMap(a -> a[0], a -> a[1], (k1, k2) -> k2));
        }
    }

    @Override
    public int compareTo(ImportTitleParam importTitleParam) {
        return this.colNum - importTitleParam.colNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public boolean isRequired() {
        return this.required;
    }

    public ImportTitleParam setColNum(int colNum) {
        this.colNum = colNum;
        return this;
    }

    public ImportTitleParam setRequired(boolean required) {
        this.required = required;
        return this;
    }

    @Override
    public String toString() {
        return "ImportTitleParam(colNum=" + this.getColNum() + ", required=" + this.isRequired() + ")";
    }

    public ImportTitleParam() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportTitleParam)) {
            return false;
        }
        ImportTitleParam other = (ImportTitleParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getColNum() != other.getColNum()) {
            return false;
        }
        return this.isRequired() == other.isRequired();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImportTitleParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getColNum();
        result = result * 59 + (this.isRequired() ? 79 : 97);
        return result;
    }
}

