/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handle;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.enums.ExcelType;
import top.lshaci.framework.excel.enums.ExportError;
import top.lshaci.framework.excel.exception.ExportHandlerException;
import top.lshaci.framework.excel.service.ExportService;

public class ExportHandler {
    private static final int XLSX_MAX_SIZE = 10000;

    public static <E> Workbook export(Class<E> cls, List<E> datas) {
        return ExportHandler.export(cls, datas, null);
    }

    public static <E> Workbook export(Class<E> cls, List<E> datas, String sheetTitle) {
        ExportHandler.verifyParam(cls);
        Workbook workbook = ExportHandler.getWorkbook(cls, CollectionUtils.isEmpty(datas) ? 0 : datas.size());
        new ExportService(cls, datas, workbook, sheetTitle).create();
        return workbook;
    }

    private static void verifyParam(Class<?> cls) {
        if (Objects.isNull(cls)) {
            throw new ExportHandlerException(ExportError.ENTITY_IS_NULL);
        }
    }

    private static Workbook getWorkbook(Class<?> cls, int size) {
        ExportSheet exportSheet = cls.getAnnotation(ExportSheet.class);
        if (Objects.isNull(exportSheet)) {
            return new XSSFWorkbook();
        }
        if (ExcelType.XLS.equals((Object)exportSheet.type())) {
            return new HSSFWorkbook();
        }
        if (size < 10000) {
            return new XSSFWorkbook();
        }
        return new SXSSFWorkbook();
    }
}

