/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.handle.ExportHandler;

public class ExcelExportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtils.class);

    public static <E> void export(Class<E> cls, List<E> datas, OutputStream os) {
        ExcelExportUtils.export(cls, datas, null, os);
    }

    public static <E> void export(Class<E> cls, List<E> datas, String sheetTitle, OutputStream os) {
        try (Workbook workbook = ExportHandler.export(cls, datas, sheetTitle);){
            workbook.write(os);
        }
        catch (IOException e) {
            log.error("\u5bfc\u51faExcel\u5de5\u4f5c\u7c3f\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ExcelHandlerException("\u5bfc\u51faExcel\u5de5\u4f5c\u7c3f\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }
}

