/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.ExcelEntity;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.annotation.ExportTitle;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.entity.ExportTitleParam;
import top.lshaci.framework.excel.enums.ExportError;
import top.lshaci.framework.excel.exception.ExportHandlerException;
import top.lshaci.framework.excel.service.utils.ExportValueUtil;
import top.lshaci.framework.utils.ClassUtils;
import top.lshaci.framework.utils.ReflectionUtils;

public class ExportService {
    private static final Logger log = LoggerFactory.getLogger(ExportService.class);
    private Class<?> cls;
    private List<?> datas;
    private Workbook workbook;
    private ExportSheetParam sheetParam;
    private List<ExportTitleParam> titleParams;
    private List<ExportTitleParam> contentParams;
    private int currentRowNumber;
    private Sheet sheet;
    private CellStyle sheetTitleStyle;
    private CellStyle columnTitleStyle;
    private CellStyle contentStyle;
    private ExportTitleParam collectionTitleParam;

    public ExportService(Class<?> cls, List<?> datas, Workbook workbook, String sheetTitle) {
        this.cls = cls;
        this.datas = datas;
        this.workbook = workbook;
        int total = CollectionUtils.isEmpty(datas) ? 0 : datas.size();
        this.sheetParam = new ExportSheetParam(cls.getAnnotation(ExportSheet.class), total);
        this.sheetTitleStyle = this.sheetParam.getCellStyleBuilder().sheetTitleStyle(workbook, this.sheetParam);
        this.columnTitleStyle = this.sheetParam.getCellStyleBuilder().columnTitleStyle(workbook, this.sheetParam);
        this.contentStyle = this.sheetParam.getCellStyleBuilder().contentStyle(workbook, this.sheetParam);
        if (StringUtils.isNotBlank((CharSequence)sheetTitle)) {
            this.sheetParam.setTitle(sheetTitle);
        }
    }

    public void create() {
        this.handleTitleParams();
        Stream.iterate(0, n -> n + 1).limit(this.sheetParam.getNumber().intValue()).forEach(n -> {
            this.currentRowNumber = 0;
            this.sheetParam.getIndexBuilder().reset();
            this.sheet = this.workbook.createSheet(this.sheetParam.getName() + "_" + (n + 1));
            this.setColumnWidth();
            this.setSheetTitle();
            this.setColumnTitles();
            if (CollectionUtils.isEmpty(this.datas)) {
                return;
            }
            if (this.sheetParam.isFreezeTitle()) {
                this.sheet.createFreezePane(0, this.currentRowNumber, 0, this.currentRowNumber);
            }
            int size = this.sheetParam.getSize();
            int end = (n + 1) * size;
            end = end > this.datas.size() ? this.datas.size() : end;
            this.datas.subList(n * size, end).forEach(this::setRowContent);
        });
    }

    private void setRowContent(Object data) {
        if (Objects.nonNull(this.collectionTitleParam)) {
            this.handleHasCollection(data);
        } else {
            Row row = this.sheet.createRow(this.currentRowNumber++);
            for (int i = 0; i < this.contentParams.size(); ++i) {
                ExportTitleParam titleParam = this.contentParams.get(i);
                String cellValue = ExportValueUtil.fetch(titleParam, data);
                this.setContentCellValue(row, titleParam.getHeight(), i, cellValue);
            }
        }
    }

    private void handleHasCollection(Object data) {
        Row row = this.sheet.createRow(this.currentRowNumber);
        Collection collectionValue = (Collection)ReflectionUtils.getFieldValue((Object)data, (Field)this.collectionTitleParam.getEntityField());
        block0: for (int i = 0; i < this.contentParams.size(); ++i) {
            ExportTitleParam titleParam = this.contentParams.get(i);
            if (CollectionUtils.isEmpty((Collection)collectionValue)) {
                String cellValue = titleParam.isCollection() ? "" : ExportValueUtil.fetch(titleParam, data);
                this.setContentCellValue(row, titleParam.getHeight(), i, cellValue);
                continue;
            }
            int crn = this.currentRowNumber;
            for (Object value : collectionValue) {
                Row nextRow;
                String cellValue = "";
                if (titleParam.isCollection()) {
                    cellValue = Objects.isNull(value) ? "" : value.toString();
                    cellValue = Objects.isNull(titleParam.getMethod()) ? cellValue : ExportValueUtil.fetch(titleParam, value);
                } else {
                    cellValue = ExportValueUtil.fetch(titleParam, data);
                }
                Row row2 = nextRow = this.sheet.getRow(crn) == null ? this.sheet.createRow(crn) : this.sheet.getRow(crn);
                if (!titleParam.isCollection() && collectionValue.size() > 1 && titleParam.isMerge()) {
                    this.cellMerge(row, this.contentStyle, cellValue, this.currentRowNumber, this.currentRowNumber + collectionValue.size() - 1, i, i);
                    continue block0;
                }
                if (!titleParam.isCollection() && !titleParam.isFillSame() && crn != this.currentRowNumber) {
                    cellValue = titleParam.getFillValue();
                }
                this.setContentCellValue(nextRow, titleParam.getHeight(), i, cellValue);
                ++crn;
            }
        }
        this.currentRowNumber += CollectionUtils.isEmpty((Collection)collectionValue) ? 1 : collectionValue.size();
    }

    private void setContentCellValue(Row row, int rowHeight, int columnNumber, String cellValue) {
        row.setHeight((short)(rowHeight * 20));
        Cell cell = row.createCell(columnNumber);
        cell.setCellValue(cellValue);
        cell.setCellStyle(this.contentStyle);
    }

    private void setColumnWidth() {
        this.sheet.setDefaultColumnWidth(12);
        for (int i = 0; i < this.contentParams.size(); ++i) {
            ExportTitleParam titleParam = this.contentParams.get(i);
            this.sheet.setColumnWidth(i, titleParam.getWidth() * 256);
        }
    }

    private void setColumnTitles() {
        Row row1 = this.sheet.createRow(this.currentRowNumber);
        row1.setHeight(this.sheetParam.getColumnTitleHeight());
        if (this.contentParams.size() > this.titleParams.size()) {
            Row row2 = this.sheet.createRow(this.currentRowNumber + 1);
            row2.setHeight(this.sheetParam.getColumnTitleHeight());
            this.setColumnTitles(row1, row2);
            this.currentRowNumber += 2;
        } else {
            for (int i = 0; i < this.titleParams.size(); ++i) {
                this.columnTitleCell(row1, i, this.titleParams.get(i).getTitle());
            }
            ++this.currentRowNumber;
        }
    }

    private void setColumnTitles(Row row1, Row row2) {
        int cn = 0;
        for (int i = 0; i < this.titleParams.size(); ++i) {
            ExportTitleParam titleParam = this.titleParams.get(i);
            List<ExportTitleParam> children = titleParam.getChildren();
            if (CollectionUtils.isEmpty(children)) {
                this.cellMerge(row1, this.columnTitleStyle, titleParam.getTitle(), this.currentRowNumber, this.currentRowNumber + 1, cn, cn);
                ++cn;
                continue;
            }
            this.cellMerge(row1, this.columnTitleStyle, titleParam.getTitle(), this.currentRowNumber, this.currentRowNumber, cn, cn + children.size() - 1);
            for (int j = 0; j < children.size(); ++j) {
                this.columnTitleCell(row2, cn++, children.get(j).getTitle());
            }
        }
    }

    private void columnTitleCell(Row row, int cn, String title) {
        Cell childrenCell = row.createCell(cn);
        childrenCell.setCellValue(title);
        childrenCell.setCellStyle(this.columnTitleStyle);
    }

    private void cellMerge(Row row, CellStyle cellStyle, String value, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.sheet.addMergedRegion(region);
        Cell cell = row.createCell(firstCol);
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
        this.sheetParam.getCellStyleBuilder().setMergeCellBorder(region, this.sheet);
    }

    private void setSheetTitle() {
        String title = this.sheetParam.getTitle();
        if (StringUtils.isBlank((CharSequence)title)) {
            return;
        }
        Row row = this.sheet.createRow(this.currentRowNumber++);
        row.setHeight(this.sheetParam.getTitleHeight());
        this.cellMerge(row, this.sheetTitleStyle, this.sheetParam.getTitle(), 0, 0, 0, this.contentParams.size() - 1);
    }

    private void handleTitleParams() {
        List<ExportTitleParam> titleParams = this.fetchTitleParams(this.cls);
        titleParams.addAll(this.getEntities(this.cls));
        titleParams.addAll(this.getCollections(this.cls));
        if (this.sheetParam.isAddIndex()) {
            titleParams.add(new ExportTitleParam(this.sheetParam));
        }
        ArrayList groupTitleParams = new ArrayList();
        titleParams.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getGroupName())).sorted().collect(Collectors.groupingBy(ExportTitleParam::getGroupName)).forEach((k, v) -> {
            List<ExportTitleParam> children = v.stream().sorted().collect(Collectors.toList());
            ExportTitleParam titleParam = new ExportTitleParam().setChildren(children).setOrder(((ExportTitleParam)v.get(0)).getOrder());
            titleParam.setTitle((String)k);
            groupTitleParams.add(titleParam);
        });
        List singleTitleParams = titleParams.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getGroupName())).collect(Collectors.toList());
        singleTitleParams.addAll(groupTitleParams);
        this.titleParams = singleTitleParams.stream().sorted().collect(Collectors.toList());
        this.contentParams = this.titleParams.stream().flatMap(e -> {
            if (CollectionUtils.isEmpty(e.getChildren())) {
                return Arrays.asList(e).stream();
            }
            return e.getChildren().stream();
        }).collect(Collectors.toList());
        this.collectionTitleParam = this.contentParams.stream().filter(ExportTitleParam::isCollection).findFirst().orElse(null);
    }

    private List<ExportTitleParam> fetchTitleParams(Class<?> cls) {
        HashMap<String, ExportTitleParam> titleParamMap = new HashMap<String, ExportTitleParam>();
        this.getFields(cls, titleParamMap);
        this.getMethods(cls, titleParamMap);
        return titleParamMap.values().stream().collect(Collectors.toList());
    }

    private void getFields(Class<?> cls, Map<String, ExportTitleParam> titleParamMap) {
        if (cls == Object.class) {
            return;
        }
        Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return !exportTitle.isEntity() && !exportTitle.isCollection();
        }).forEach(f -> {
            if (titleParamMap.get(f.getName()) == null) {
                titleParamMap.put(f.getName(), new ExportTitleParam((Field)f, cls));
            }
        });
        this.getFields(cls.getSuperclass(), titleParamMap);
    }

    private void getMethods(Class<?> cls, Map<String, ExportTitleParam> titleParamMap) {
        if (cls == Object.class) {
            return;
        }
        Arrays.stream(cls.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ExportTitle.class))).filter(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return !exportTitle.isEntity() && !exportTitle.isCollection();
        }).forEach(m -> {
            if (titleParamMap.get(m.getName()) == null) {
                titleParamMap.put(m.getName(), new ExportTitleParam((Method)m));
            }
        });
        this.getMethods(cls.getSuperclass(), titleParamMap);
    }

    private List<ExportTitleParam> getEntities(Class<?> cls) {
        return Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isEntity()).filter(f -> {
            ExcelEntity excelEntity = f.getType().getAnnotation(ExcelEntity.class);
            if (Objects.isNull(excelEntity)) {
                log.error("{}\u672a\u4f7f\u7528ExcelEntity\u6ce8\u89e3\u6807\u8bb0", f.getType());
                throw new ExportHandlerException(ExportError.NOT_EXCEL_ENTITY);
            }
            return true;
        }).flatMap(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return this.fetchTitleParams(f.getType()).stream().map(e -> e.setEntityField((Field)f).setGroupName(exportTitle.title()).setOrder((double)exportTitle.order() + e.getOrder() / 100.0));
        }).collect(Collectors.toList());
    }

    private List<ExportTitleParam> getCollections(Class<?> cls) {
        long count = Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isCollection()).count();
        if (count > 1L) {
            throw new ExportHandlerException(ExportError.ANY_ONE_COLLECTION);
        }
        return Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isCollection()).filter(f -> {
            if (!Collection.class.isAssignableFrom(f.getType())) {
                log.error("\u4f7f\u7528ExportTitle\u6ce8\u89e3\u6807\u8bb0\u7684\u5b57\u6bb5{}\u4e0d\u662f\u96c6\u5408\u7c7b\u578b", (Object)f.getName());
                throw new ExportHandlerException(ExportError.NOT_COLLECTION);
            }
            return true;
        }).flatMap(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            Class fieldGenericType = ClassUtils.getFieldGenericType((Field)f);
            ExcelEntity excelEntity = fieldGenericType.getAnnotation(ExcelEntity.class);
            if (Objects.nonNull(excelEntity)) {
                return this.fetchTitleParams(fieldGenericType).stream().map(e -> e.setEntityField((Field)f).setCollection(true).setGroupName(exportTitle.title()).setOrder((double)exportTitle.order() + e.getOrder() / 100.0));
            }
            ExportTitleParam titleParam = new ExportTitleParam((Field)f, cls).setCollection(true).setEntityField((Field)f);
            titleParam.setMethod(null);
            return Arrays.asList(titleParam).stream();
        }).collect(Collectors.toList());
    }
}

