/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.service.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ExportTitleParam;
import top.lshaci.framework.excel.service.utils.BaseValueUtil;
import top.lshaci.framework.utils.ReflectionUtils;

public class ExportValueUtil
extends BaseValueUtil {
    private static final Logger log = LoggerFactory.getLogger(ExportValueUtil.class);

    public static String fetch(ExportTitleParam titleParam, Object data) {
        if (titleParam.isIndex()) {
            return titleParam.getIndexNumber();
        }
        if (Objects.isNull(data)) {
            log.warn("\u5f53\u524d\u884c\u6570\u636e\u4e3a\u7a7a");
            return "";
        }
        Object value = ExportValueUtil.fetchOriginalValue(titleParam, data);
        if (Objects.isNull(value)) {
            log.warn("{}\u7684\u539f\u59cb\u503c\u4e3a\u7a7a", (Object)titleParam.getTitle());
            return "";
        }
        if (Objects.nonNull(titleParam.getConvertMethod())) {
            value = ExportValueUtil.getConvertValue(titleParam.getConvertClass(), titleParam.getConvertMethod(), value);
            return Objects.isNull(value) ? "" : value.toString();
        }
        if (Objects.nonNull(titleParam.getEnumMethod())) {
            return ExportValueUtil.getEnumValue(titleParam, value);
        }
        String result = value.toString();
        if (StringUtils.isBlank((CharSequence)result)) {
            log.warn("\u5355\u5143\u683c\u7684\u503c\u4e3a\u7a7a\u5b57\u7b26\uff0c\u4e0d\u4f5c\u5176\u5b83\u5904\u7406");
            return "";
        }
        if (MapUtils.isNotEmpty((Map)titleParam.getReplaceMap()) && StringUtils.isBlank((CharSequence)(result = (String)titleParam.getReplaceMap().get(result)))) {
            log.warn("\u66ff\u6362\u540e\u5355\u5143\u683c\u7684\u503c\u4e3a\u7a7a\u5b57\u7b26\uff0c\u4e0d\u4f5c\u5176\u5b83\u5904\u7406");
            return "";
        }
        return ExportValueUtil.concat(titleParam, result);
    }

    private static String getEnumValue(ExportTitleParam titleParam, Object value) {
        Object enumValue = ReflectionUtils.invokeMethod((Object)value, (Method)titleParam.getEnumMethod(), (Object[])new Object[0]);
        if (Objects.isNull(enumValue)) {
            log.warn("\u6267\u884c\u679a\u4e3e\u65b9\u6cd5\u540e\u83b7\u53d6\u5230\u7684\u503c\u4e3a\u7a7a");
            return "";
        }
        return enumValue.toString();
    }

    private static Object fetchOriginalValue(ExportTitleParam titleParam, Object data) {
        Object value = null;
        if (Objects.nonNull(titleParam.getEntityField()) && !titleParam.isCollection()) {
            log.debug("\u5f53\u524d\u5b57\u6bb5\u4e3a\u5185\u5d4c\u5bf9\u8c61\u7684\u5b57\u6bb5");
            Object obj = ReflectionUtils.getFieldValue((Object)data, (Field)titleParam.getEntityField());
            if (Objects.nonNull(obj)) {
                value = ReflectionUtils.invokeMethod((Object)obj, (Method)titleParam.getMethod(), (Object[])new Object[0]);
            }
        } else {
            value = ReflectionUtils.invokeMethod((Object)data, (Method)titleParam.getMethod(), (Object[])new Object[0]);
        }
        return value;
    }

    private static String concat(ExportTitleParam titleParam, String value) {
        return titleParam.getPrefix() + value + titleParam.getSuffix();
    }
}

