/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ImportSheetParam;
import top.lshaci.framework.excel.exception.ExcelHandlerException;
import top.lshaci.framework.excel.handle.ImportHandler;

public class ExcelImportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtils.class);

    public static <E> List<E> parse(File file, Class<E> cls) {
        return ExcelImportUtils.parse(file, cls, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> List<E> parse(File file, Class<E> cls, ImportSheetParam sheetParam) {
        try (FileInputStream is = new FileInputStream(file);){
            List<E> list = ExcelImportUtils.parse(is, cls, sheetParam);
            return list;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6Excel\u6587\u4ef6\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ExcelHandlerException("\u83b7\u53d6Excel\u6587\u4ef6\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls) {
        return ExcelImportUtils.parse(is, cls, null);
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls, ImportSheetParam sheetParam) {
        return ImportHandler.parse(is, cls, sheetParam);
    }
}

