/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handle;

import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Workbook;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.enums.ExportError;
import top.lshaci.framework.excel.exception.ExportHandlerException;
import top.lshaci.framework.excel.service.ExportService;

public class ExportHandler {
    public static <E> Workbook export(Class<E> cls, List<E> datas, ExportSheetParam sheetParam, ExportService exportService) {
        if (Objects.isNull(cls)) {
            throw new ExportHandlerException(ExportError.ENTITY_IS_NULL);
        }
        sheetParam = Objects.nonNull(sheetParam) ? sheetParam : ExportSheetParam.build(cls.getAnnotation(ExportSheet.class));
        exportService = Objects.nonNull(exportService) ? exportService : ExportService.get();
        return exportService.create(cls, datas, sheetParam);
    }
}

