/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ImportSheetParam;
import top.lshaci.framework.excel.enums.ImportError;
import top.lshaci.framework.excel.exception.ImportHandlerException;
import top.lshaci.framework.excel.service.impl.DefaultImportService;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.StreamUtils;
import top.lshaci.framework.utils.enums.FileType;

public class ImportHandler {
    private static final Logger log = LoggerFactory.getLogger(ImportHandler.class);
    private static final List<FileType> ALLOW_FILE_TYPES = Arrays.asList(FileType.XLSX_DOCX, FileType.XLS_DOC, FileType.WPS, FileType.WPSX);

    public static <E> List<E> parse(InputStream is, Class<E> cls) {
        return ImportHandler.parse(is, cls, null);
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls, ImportSheetParam sheetParam) {
        ImportHandler.verifyParam(is, cls);
        ByteArrayOutputStream buffer = StreamUtils.copyInputStream((InputStream)is);
        Workbook workbook = ImportHandler.getWorkBook(buffer);
        return new DefaultImportService(cls, workbook, sheetParam).fetch();
    }

    private static void verifyParam(InputStream is, Class<?> cls) {
        if (Objects.isNull(cls)) {
            throw new ImportHandlerException(ImportError.ENTITY_IS_NULL);
        }
        if (Objects.isNull(is)) {
            throw new ImportHandlerException(ImportError.DATA_IS_NULL);
        }
    }

    private static Workbook getWorkBook(ByteArrayOutputStream buffer) {
        FileType fileType = ImportHandler.getFileType(buffer);
        XSSFWorkbook workbook = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());){
            if (FileType.XLSX_DOCX.equals((Object)fileType) || FileType.WPSX.equals((Object)fileType)) {
                workbook = new XSSFWorkbook((InputStream)is);
            }
            if (FileType.XLS_DOC.equals((Object)fileType) || FileType.WPS.equals((Object)fileType)) {
                workbook = new HSSFWorkbook((InputStream)is);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efaExcel\u5de5\u4f5c\u7c3f\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        if (workbook == null) {
            throw new ImportHandlerException(ImportError.WORKBOOK_IS_NULL);
        }
        return workbook;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileType getFileType(ByteArrayOutputStream buffer) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());){
            FileType fileType2 = FileTypeUtil.getType((InputStream)is);
            if (!ALLOW_FILE_TYPES.contains(fileType2)) throw new ImportHandlerException(ImportError.NOT_EXCEL);
            FileType fileType = fileType2;
            return fileType;
        }
        catch (Exception e) {
            log.error(ImportError.FETCH_EXCEL_TYPE_ERROR.getMsg(), (Throwable)e);
            throw new ImportHandlerException(ImportError.FETCH_EXCEL_TYPE_ERROR, e);
        }
    }
}

