/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.service.impl;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.ImportTitle;
import top.lshaci.framework.excel.entity.ImportSheetParam;
import top.lshaci.framework.excel.entity.ImportTitleParam;
import top.lshaci.framework.excel.enums.ImportError;
import top.lshaci.framework.excel.exception.ImportHandlerException;
import top.lshaci.framework.excel.service.impl.ImportValueUtil;
import top.lshaci.framework.utils.ReflectionUtils;

public class DefaultImportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultImportService.class);
    private Class<?> cls;
    private Sheet sheet;
    private ImportSheetParam sheetParam;
    private List<ImportTitleParam> titleParams;

    public DefaultImportService(Class<?> cls, Workbook workbook, ImportSheetParam sheetParam) {
        this.cls = cls;
        this.sheetParam = Objects.isNull(sheetParam) ? new ImportSheetParam() : sheetParam;
        this.sheet = this.fetchSheet(workbook);
        this.titleParams = new ArrayList<ImportTitleParam>();
    }

    public List<?> fetch() {
        this.handleTitleParams();
        return Stream.iterate(this.sheetParam.getTitleRow() + 1, n -> n + 1).limit(this.sheet.getLastRowNum()).map(arg_0 -> ((Sheet)this.sheet).getRow(arg_0)).filter(Objects::nonNull).map(this::row2Obj).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Object row2Obj(Row row) {
        Object obj = ReflectionUtils.newInstance(this.cls);
        ArrayList values = new ArrayList();
        this.titleParams.forEach(p -> {
            Cell cell = row.getCell(p.getColNum());
            Object value = ImportValueUtil.getTargetValue(cell, p);
            this.verifyValue(row, (ImportTitleParam)p, value);
            ReflectionUtils.invokeMethod((Object)obj, (Method)p.getMethod(), (Object[])new Object[]{value});
            values.add(value);
        });
        return values.stream().filter(Objects::isNull).count() == (long)values.size() ? null : obj;
    }

    private void verifyValue(Row row, ImportTitleParam titleParam, Object value) {
        if (Objects.isNull(value) && titleParam.isRequired()) {
            int rn = row.getRowNum() + 1;
            int cn = titleParam.getColNum() + 1;
            log.error("[{}]\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a; \u7b2c{}\u884c, \u7b2c{}\u5217\u7684\u503c\u89e3\u6790\u540e\u4e3a\u7a7a", new Object[]{titleParam.getTitle(), rn, cn});
            throw new ImportHandlerException("\u7b2c" + rn + "\u884c, \u7b2c" + cn + "\u5217\u7684\u503c\u89e3\u6790\u540e\u4e3a\u7a7a");
        }
    }

    private Sheet fetchSheet(Workbook workbook) {
        Sheet sheet = null;
        sheet = StrUtil.isNotBlank((CharSequence)this.sheetParam.getName()) ? workbook.getSheet(this.sheetParam.getName()) : workbook.getSheetAt(this.sheetParam.getIndex());
        if (Objects.isNull(sheet)) {
            throw new ImportHandlerException(ImportError.SHEET_NOT_EXIST);
        }
        return sheet;
    }

    private void handleTitleParams() {
        Map<String, ImportTitleParam> titleParamMap = this.fetchTitleParams();
        Row row = this.sheet.getRow(this.sheetParam.getTitleRow());
        if (Objects.isNull(row) || row.getLastCellNum() == -1) {
            log.error("{}\u884c\u4e0d\u5b58\u5728\u6570\u636e", (Object)this.sheetParam.getTitleRow());
            throw new ImportHandlerException(ImportError.TITLE_ROW_NOT_EXIST);
        }
        row.forEach(c -> {
            String title = ImportValueUtil.get(c);
            if (Objects.isNull(title)) {
                return;
            }
            ImportTitleParam titleParam = (ImportTitleParam)titleParamMap.get(title);
            if (Objects.isNull(titleParam)) {
                log.warn("[{}]\u672a\u5b9a\u4e49\u4e3a\u9700\u8981\u5bfc\u5165\u7684\u5217", (Object)title);
                if (this.sheetParam.isForceEntity()) {
                    throw new ImportHandlerException(ImportError.INVALID_TEMPLATE);
                }
            } else {
                titleParamMap.remove(title);
                titleParam.setColNum(c.getColumnIndex());
                this.titleParams.add(titleParam);
            }
        });
        if (MapUtils.isNotEmpty(titleParamMap) && this.sheetParam.isForceSheet()) {
            log.warn("{}\u5217\u5728Excel\u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728", titleParamMap.keySet());
            throw new ImportHandlerException(ImportError.INVALID_TEMPLATE);
        }
    }

    private Map<String, ImportTitleParam> fetchTitleParams() {
        HashMap<String, ImportTitleParam> titleParamMap = new HashMap<String, ImportTitleParam>();
        this.getFields(this.cls, titleParamMap);
        if (MapUtils.isEmpty(titleParamMap)) {
            throw new ImportHandlerException(ImportError.NOT_DEFINE_IMPORT_COLUMN);
        }
        return titleParamMap;
    }

    private void getFields(Class<?> cls, Map<String, ImportTitleParam> titleParamMap) {
        if (cls == Object.class) {
            return;
        }
        Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ImportTitle.class))).forEach(f -> {
            String title = f.getAnnotation(ImportTitle.class).title();
            if (StrUtil.isNotBlank((CharSequence)title)) {
                titleParamMap.put(title, new ImportTitleParam((Field)f, cls));
            }
        });
        this.getFields(cls.getSuperclass(), titleParamMap);
    }
}

