package top.lshaci.framework.excel.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * ExcelHandleError
 *
 * @author lshaci
 * @since 1.0.9
 */
@Getter
@AllArgsConstructor
public enum ExcelHandleErrorInfo implements ErrorInfo {
	/**
	 * 转换方法不存在
	 */
	convert_method_not_exists(502_0_01, "转换方法不存在"),
	/**
	 * 禁止使用boolean类型
	 */
	prohibited_use_boolean(502_0_02, "禁止使用boolean类型"),
	/**
	 * 方法不存在
	 */
	method_not_exists(502_0_03, "方法不存在"),
	/**
	 * 当前列不是序号列
	 */
	not_index_column(502_0_04, "当前列不是序号列"),
	;

	/**
	 * 异常码
	 */
	private final int code;
	/**
	 * 异常信息
	 */
	private final String msg;

}
