package top.lshaci.framework.excel.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * 导出Excel时的错误信息
 *
 * @author lshaci
 * @since 1.0.2
 * @version 1.0.9
 */
@Getter
@AllArgsConstructor
public enum ExportHandleErrorInfo implements ErrorInfo {
	/**
	 * 导出对象类型不能为空
	 */
	entity_is_null(502_2_01, "导出对象类型为空"),
	/**
	 * 导出实体未使用ExcelEntity注解标记
	 */
	not_excel_entity(502_2_02, "导出实体未使用ExcelEntity注解标记"),
	/**
	 * 导出实体类仅允许标记一个集合类型字段
	 */
	only_one_collection(502_2_03, "导出实体类仅允许标记一个集合类型字段"),
	/**
	 * 使用ExportTitle注解标记的字段不是集合类型
	 */
	not_collection(502_2_04, "使用ExportTitle注解标记的字段不是集合类型"),
	/**
	 * 导出Excel工作簿时发生错误
	 */
	failure(502_2_05, "导出Excel工作簿时发生错误"),
	;

	/**
	 * 异常码
	 */
	private final int code;
	/**
	 * 异常信息
	 */
	private final String msg;

}
