package top.lshaci.framework.excel.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import top.lshaci.framework.common.constants.ErrorInfo;

/**
 * 导入时的错误信息
 *
 * @author lshaci
 * @since 1.0.2
 * @version 1.0.9
 */
@Getter
@AllArgsConstructor
public enum ImportHandleErrorInfo implements ErrorInfo {
	/**
	 * 导入的数据为空
	 */
	data_is_null(502_1_01, "导入的数据为空"),
	/**
	 * 导入对象类型为空
	 */
	entity_is_null(502_1_02, "导入对象类型为空"),
	/**
	 * 上传的文件不是Excel格式
	 */
	not_excel(502_1_03, "上传的文件不是Excel格式"),
	/**
	 * 标题行不存在
	 */
	title_row_not_exist(502_1_04, "标题行不存在"),
	/**
	 * Excel工作表不存在
	 */
	sheet_not_exist(502_1_05, "Excel工作表不存在"),
	/**
	 * 未使用正确的Excel模板
	 */
	invalid_template(502_1_06, "未使用正确的Excel模板"),
	/**
	 * 未从导入数据中获取到Excel工作簿
	 */
	workbook_is_null(502_1_07, "未从导入数据中获取到Excel工作簿"),
	/**
	 * 导入对象类型中未定义需要导入的列
	 */
	not_define_import_column(502_1_08, "导入对象类型中未定义需要导入的列"),
	/**
	 * 从导入数据中获取Excel类型发生错误
	 */
	fetch_excel_type_error(502_1_09, "从导入数据中获取Excel类型发生错误"),
	/**
	 * 导入Excel工作簿时发生错误
	 */
	failure(502_1_10, "导入Excel工作簿时发生错误"),
	/**
	 * 单元格数据为空
	 */
	cell_data_is_null(502_1_11, "第{}行, 第{}列的值解析后为空"),
	;

	/**
	 * 异常码
	 */
	private final int code;
	/**
	 * 异常信息
	 */
	private final String msg;

}
