/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.builder.impl;

import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import top.lshaci.framework.excel.builder.CellStyleBuilder;

public class DefaultCellStyleBuilder
implements CellStyleBuilder {
    @Override
    public void setMergeCellBorder(CellRangeAddress region, Sheet sheet) {
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
    }

    @Override
    public CellStyle contentStyle(Workbook workbook, String fontName) {
        CellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK, (short)10, false, fontName);
        style.setFont(font);
        return style;
    }

    @Override
    public CellStyle sheetTitleStyle(Workbook workbook, String fontName) {
        CellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK, (short)20, true, fontName);
        style.setFont(font);
        return style;
    }

    @Override
    public CellStyle columnTitleStyle(Workbook workbook, String fontName) {
        CellStyle style = workbook.createCellStyle();
        this.setBorder(style);
        this.setCenter(style);
        Font font = this.createFont(workbook, IndexedColors.BLACK, (short)12, true, fontName);
        style.setFont(font);
        return style;
    }
}

