/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.entity;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.enums.ExcelHandleErrorInfo;
import top.lshaci.framework.excel.exception.ExcelHandleException;

class BaseTitleParam {
    private static final Logger log = LoggerFactory.getLogger(BaseTitleParam.class);
    protected String title;
    protected String prefix = "";
    protected String suffix = "";
    protected Field field;
    protected Method method;
    protected Class<?> convertClass;
    protected Method convertMethod;
    protected Map<String, String> replaceMap;

    protected void buildConvertMethod(Class<?> convertClass, String methodName, Class<?> ... args) {
        if (Void.class != convertClass && StrUtil.isNotBlank((CharSequence)methodName)) {
            try {
                this.convertClass = convertClass;
                this.convertMethod = convertClass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.error("{}.{}\u8f6c\u6362\u65b9\u6cd5\u4e0d\u5b58\u5728", convertClass, (Object)methodName);
                throw new ExcelHandleException(ExcelHandleErrorInfo.convert_method_not_exists, new Object[0]);
            }
        }
    }

    protected Method createByField(Field field, Class<?> cls, MethodType methodType, Class<?> ... args) {
        String name = field.getName();
        if (field.getType() == Boolean.TYPE) {
            throw new ExcelHandleException(ExcelHandleErrorInfo.prohibited_use_boolean, new Object[0]);
        }
        String methodName = methodType.des + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            return cls.getMethod(methodName, args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            log.error("{}\u7684{}\u65b9\u6cd5\u4e0d\u5b58\u5728", cls, (Object)methodName);
            throw new ExcelHandleException(ExcelHandleErrorInfo.method_not_exists, new Object[0]);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Field getField() {
        return this.field;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getConvertClass() {
        return this.convertClass;
    }

    public Method getConvertMethod() {
        return this.convertMethod;
    }

    public Map<String, String> getReplaceMap() {
        return this.replaceMap;
    }

    public BaseTitleParam setTitle(String title) {
        this.title = title;
        return this;
    }

    public BaseTitleParam setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public BaseTitleParam setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public BaseTitleParam setField(Field field) {
        this.field = field;
        return this;
    }

    public BaseTitleParam setMethod(Method method) {
        this.method = method;
        return this;
    }

    public BaseTitleParam setConvertClass(Class<?> convertClass) {
        this.convertClass = convertClass;
        return this;
    }

    public BaseTitleParam setConvertMethod(Method convertMethod) {
        this.convertMethod = convertMethod;
        return this;
    }

    public BaseTitleParam setReplaceMap(Map<String, String> replaceMap) {
        this.replaceMap = replaceMap;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTitleParam)) {
            return false;
        }
        BaseTitleParam other = (BaseTitleParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        Class<?> this$convertClass = this.getConvertClass();
        Class<?> other$convertClass = other.getConvertClass();
        if (this$convertClass == null ? other$convertClass != null : !this$convertClass.equals(other$convertClass)) {
            return false;
        }
        Method this$convertMethod = this.getConvertMethod();
        Method other$convertMethod = other.getConvertMethod();
        if (this$convertMethod == null ? other$convertMethod != null : !((Object)this$convertMethod).equals(other$convertMethod)) {
            return false;
        }
        Map<String, String> this$replaceMap = this.getReplaceMap();
        Map<String, String> other$replaceMap = other.getReplaceMap();
        return !(this$replaceMap == null ? other$replaceMap != null : !((Object)this$replaceMap).equals(other$replaceMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseTitleParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        Class<?> $convertClass = this.getConvertClass();
        result = result * 59 + ($convertClass == null ? 43 : $convertClass.hashCode());
        Method $convertMethod = this.getConvertMethod();
        result = result * 59 + ($convertMethod == null ? 43 : ((Object)$convertMethod).hashCode());
        Map<String, String> $replaceMap = this.getReplaceMap();
        result = result * 59 + ($replaceMap == null ? 43 : ((Object)$replaceMap).hashCode());
        return result;
    }

    public String toString() {
        return "BaseTitleParam(title=" + this.getTitle() + ", prefix=" + this.getPrefix() + ", suffix=" + this.getSuffix() + ", field=" + this.getField() + ", method=" + this.getMethod() + ", convertClass=" + this.getConvertClass() + ", convertMethod=" + this.getConvertMethod() + ", replaceMap=" + this.getReplaceMap() + ")";
    }

    protected static enum MethodType {
        SET("set"),
        GET("get");

        private final String des;

        private MethodType(String des) {
            this.des = des;
        }
    }
}

