/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.entity;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.builder.CellStyleBuilder;
import top.lshaci.framework.excel.builder.IndexBuilder;
import top.lshaci.framework.excel.builder.impl.DefaultCellStyleBuilder;
import top.lshaci.framework.excel.builder.impl.DefaultIndexBuilder;

public class ExportSheetParam {
    private String title;
    private short titleHeight = (short)720;
    private short columnTitleHeight = (short)480;
    private String name;
    private Integer number = 1;
    private boolean addIndex = true;
    private boolean mergeIndex = true;
    private boolean freezeTitle = false;
    private String indexName = "\u5e8f\u53f7";
    private int indexWidth = 8;
    private String fontName = "\u5b8b\u4f53";
    private int size;
    private CellStyleBuilder cellStyleBuilder = new DefaultCellStyleBuilder();
    private IndexBuilder indexBuilder = new DefaultIndexBuilder();

    public static ExportSheetParam build(ExportSheet exportSheet) {
        ExportSheetParam param = new ExportSheetParam();
        if (Objects.isNull(exportSheet)) {
            return param;
        }
        param.addIndex = exportSheet.addIndex();
        param.mergeIndex = exportSheet.mergeIndex();
        param.freezeTitle = exportSheet.freezeTitle();
        param.cellStyleBuilder = (CellStyleBuilder)ReflectUtil.newInstance(exportSheet.cellStyleBuilder(), (Object[])new Object[0]);
        param.indexBuilder = (IndexBuilder)ReflectUtil.newInstance(exportSheet.indexBuilder(), (Object[])new Object[0]);
        if (StrUtil.isNotBlank((CharSequence)exportSheet.fontName())) {
            param.fontName = exportSheet.fontName();
        }
        if (StrUtil.isNotBlank((CharSequence)exportSheet.indexName())) {
            param.indexName = exportSheet.indexName();
        }
        if (StrUtil.isNotBlank((CharSequence)exportSheet.title())) {
            param.title = exportSheet.title();
        }
        if (StrUtil.isNotBlank((CharSequence)exportSheet.name())) {
            param.name = exportSheet.name();
        }
        if (exportSheet.indexWidth() > 0) {
            param.indexWidth = exportSheet.indexWidth();
        }
        if (exportSheet.number() > 0) {
            param.number = exportSheet.number();
        }
        if (exportSheet.titleHeight() > 0) {
            param.titleHeight = (short)(exportSheet.titleHeight() * 20);
        }
        if (exportSheet.columnTitleHeight() > 0) {
            param.columnTitleHeight = (short)(exportSheet.columnTitleHeight() * 20);
        }
        return param;
    }

    public ExportSheetParam setSizeAndNumber(int total) {
        if (total > 0 && total / this.number > 0) {
            Double size = Math.ceil((double)total / ((double)this.number.intValue() * 1.0));
            this.size = size.intValue();
        } else {
            this.size = total;
            this.number = 1;
        }
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public short getTitleHeight() {
        return this.titleHeight;
    }

    public short getColumnTitleHeight() {
        return this.columnTitleHeight;
    }

    public String getName() {
        return this.name;
    }

    public Integer getNumber() {
        return this.number;
    }

    public boolean isAddIndex() {
        return this.addIndex;
    }

    public boolean isMergeIndex() {
        return this.mergeIndex;
    }

    public boolean isFreezeTitle() {
        return this.freezeTitle;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndexWidth() {
        return this.indexWidth;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getSize() {
        return this.size;
    }

    public CellStyleBuilder getCellStyleBuilder() {
        return this.cellStyleBuilder;
    }

    public IndexBuilder getIndexBuilder() {
        return this.indexBuilder;
    }

    public ExportSheetParam setTitle(String title) {
        this.title = title;
        return this;
    }

    public ExportSheetParam setTitleHeight(short titleHeight) {
        this.titleHeight = titleHeight;
        return this;
    }

    public ExportSheetParam setColumnTitleHeight(short columnTitleHeight) {
        this.columnTitleHeight = columnTitleHeight;
        return this;
    }

    public ExportSheetParam setName(String name) {
        this.name = name;
        return this;
    }

    public ExportSheetParam setNumber(Integer number) {
        this.number = number;
        return this;
    }

    public ExportSheetParam setAddIndex(boolean addIndex) {
        this.addIndex = addIndex;
        return this;
    }

    public ExportSheetParam setMergeIndex(boolean mergeIndex) {
        this.mergeIndex = mergeIndex;
        return this;
    }

    public ExportSheetParam setFreezeTitle(boolean freezeTitle) {
        this.freezeTitle = freezeTitle;
        return this;
    }

    public ExportSheetParam setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ExportSheetParam setIndexWidth(int indexWidth) {
        this.indexWidth = indexWidth;
        return this;
    }

    public ExportSheetParam setFontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public ExportSheetParam setSize(int size) {
        this.size = size;
        return this;
    }

    public ExportSheetParam setCellStyleBuilder(CellStyleBuilder cellStyleBuilder) {
        this.cellStyleBuilder = cellStyleBuilder;
        return this;
    }

    public ExportSheetParam setIndexBuilder(IndexBuilder indexBuilder) {
        this.indexBuilder = indexBuilder;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportSheetParam)) {
            return false;
        }
        ExportSheetParam other = (ExportSheetParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        if (this.getTitleHeight() != other.getTitleHeight()) {
            return false;
        }
        if (this.getColumnTitleHeight() != other.getColumnTitleHeight()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Integer this$number = this.getNumber();
        Integer other$number = other.getNumber();
        if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
            return false;
        }
        if (this.isAddIndex() != other.isAddIndex()) {
            return false;
        }
        if (this.isMergeIndex() != other.isMergeIndex()) {
            return false;
        }
        if (this.isFreezeTitle() != other.isFreezeTitle()) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        if (this.getIndexWidth() != other.getIndexWidth()) {
            return false;
        }
        String this$fontName = this.getFontName();
        String other$fontName = other.getFontName();
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        CellStyleBuilder this$cellStyleBuilder = this.getCellStyleBuilder();
        CellStyleBuilder other$cellStyleBuilder = other.getCellStyleBuilder();
        if (this$cellStyleBuilder == null ? other$cellStyleBuilder != null : !this$cellStyleBuilder.equals(other$cellStyleBuilder)) {
            return false;
        }
        IndexBuilder this$indexBuilder = this.getIndexBuilder();
        IndexBuilder other$indexBuilder = other.getIndexBuilder();
        return !(this$indexBuilder == null ? other$indexBuilder != null : !this$indexBuilder.equals(other$indexBuilder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportSheetParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        result = result * 59 + this.getTitleHeight();
        result = result * 59 + this.getColumnTitleHeight();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Integer $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
        result = result * 59 + (this.isAddIndex() ? 79 : 97);
        result = result * 59 + (this.isMergeIndex() ? 79 : 97);
        result = result * 59 + (this.isFreezeTitle() ? 79 : 97);
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        result = result * 59 + this.getIndexWidth();
        String $fontName = this.getFontName();
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        result = result * 59 + this.getSize();
        CellStyleBuilder $cellStyleBuilder = this.getCellStyleBuilder();
        result = result * 59 + ($cellStyleBuilder == null ? 43 : $cellStyleBuilder.hashCode());
        IndexBuilder $indexBuilder = this.getIndexBuilder();
        result = result * 59 + ($indexBuilder == null ? 43 : $indexBuilder.hashCode());
        return result;
    }

    public String toString() {
        return "ExportSheetParam(title=" + this.getTitle() + ", titleHeight=" + this.getTitleHeight() + ", columnTitleHeight=" + this.getColumnTitleHeight() + ", name=" + this.getName() + ", number=" + this.getNumber() + ", addIndex=" + this.isAddIndex() + ", mergeIndex=" + this.isMergeIndex() + ", freezeTitle=" + this.isFreezeTitle() + ", indexName=" + this.getIndexName() + ", indexWidth=" + this.getIndexWidth() + ", fontName=" + this.getFontName() + ", size=" + this.getSize() + ", cellStyleBuilder=" + this.getCellStyleBuilder() + ", indexBuilder=" + this.getIndexBuilder() + ")";
    }
}

