/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.entity;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.ExportTitle;
import top.lshaci.framework.excel.builder.IndexBuilder;
import top.lshaci.framework.excel.entity.BaseTitleParam;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.enums.ExcelHandleErrorInfo;
import top.lshaci.framework.excel.exception.ExcelHandleException;

public class ExportTitleParam
extends BaseTitleParam
implements Comparable<ExportTitleParam> {
    private static final Logger log = LoggerFactory.getLogger(ExportTitleParam.class);
    private double order;
    private String groupName;
    private int width = 12;
    private int height = -1;
    private List<ExportTitleParam> children;
    private boolean isIndex;
    private boolean merge;
    private boolean fillSame;
    private String fillValue;
    private boolean isCollection;
    private Field entityField;
    private IndexBuilder indexBuilder;
    private Method enumMethod;

    public static ExportTitleParam indexTitle(ExportSheetParam sheetParam) {
        ExportTitleParam indexTitle = new ExportTitleParam();
        indexTitle.isIndex = true;
        indexTitle.fillSame = true;
        indexTitle.merge = sheetParam.isMergeIndex();
        indexTitle.title = sheetParam.getIndexName();
        indexTitle.order = -2.147483648E9;
        indexTitle.width = sheetParam.getIndexWidth();
        indexTitle.indexBuilder = sheetParam.getIndexBuilder();
        return indexTitle;
    }

    public ExportTitleParam(Method method) {
        this.method = method;
        this.title = method.getName();
        ExportTitle exportTitle = method.getAnnotation(ExportTitle.class);
        if (Objects.isNull(exportTitle)) {
            return;
        }
        this.build(exportTitle);
        this.buildConvertMethod(exportTitle.convertClass(), exportTitle.convertMethod(), this.method.getReturnType());
        this.buildEnumMethod(method, exportTitle);
    }

    public ExportTitleParam(Field field, Class<?> cls) {
        this.field = field;
        this.title = field.getName();
        this.method = this.createByField(field, cls, BaseTitleParam.MethodType.GET, new Class[0]);
        ExportTitle exportTitle = field.getAnnotation(ExportTitle.class);
        if (Objects.isNull(exportTitle)) {
            return;
        }
        this.build(exportTitle);
        this.buildConvertMethod(exportTitle.convertClass(), exportTitle.convertMethod(), this.method.getReturnType());
        this.buildEnumMethod(field, exportTitle);
    }

    private void buildEnumMethod(Field field, ExportTitle exportTitle) {
        if (field.getType().isEnum() && StrUtil.isNotBlank((CharSequence)exportTitle.enumMethod())) {
            try {
                this.enumMethod = field.getType().getMethod(exportTitle.enumMethod(), new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.error("{}\u4e2d\u7684{}\u65b9\u6cd5\u4e0d\u5b58\u5728", field.getType(), (Object)exportTitle.enumMethod());
                throw new ExcelHandleException(ExcelHandleErrorInfo.method_not_exists, new Object[0]);
            }
        }
    }

    private void buildEnumMethod(Method method, ExportTitle exportTitle) {
        if (method.getReturnType().isEnum() && StrUtil.isNotBlank((CharSequence)exportTitle.enumMethod())) {
            try {
                this.enumMethod = method.getReturnType().getMethod(exportTitle.enumMethod(), new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                log.error("{}\u4e2d\u7684{}\u65b9\u6cd5\u4e0d\u5b58\u5728", method.getReturnType(), (Object)exportTitle.enumMethod());
                throw new ExcelHandleException(ExcelHandleErrorInfo.method_not_exists, new Object[0]);
            }
        }
    }

    private void build(ExportTitle exportTitle) {
        this.order = exportTitle.order();
        this.merge = exportTitle.merge();
        this.fillSame = exportTitle.fillSame();
        this.fillValue = exportTitle.fillValue();
        if (StrUtil.isNotBlank((CharSequence)exportTitle.prefix())) {
            this.prefix = exportTitle.prefix();
        }
        if (StrUtil.isNotBlank((CharSequence)exportTitle.suffix())) {
            this.suffix = exportTitle.suffix();
        }
        if (StrUtil.isNotBlank((CharSequence)exportTitle.title())) {
            this.title = exportTitle.title();
        }
        if (exportTitle.width() > 0) {
            this.width = exportTitle.width();
        }
        if (exportTitle.height() > 0) {
            this.height = exportTitle.height();
        }
        if (StrUtil.isNotBlank((CharSequence)exportTitle.groupName())) {
            this.groupName = exportTitle.groupName();
        }
        if (ArrayUtil.isNotEmpty((Object[])exportTitle.replaces())) {
            this.replaceMap = Arrays.stream(exportTitle.replaces()).filter(r -> r.contains("__")).map(r -> r.split("__")).filter(a -> ((String[])a).length > 1).collect(Collectors.toMap(a -> a[0], a -> a[1], (k1, k2) -> k2));
        }
    }

    public String getIndexNumber() {
        if (this.isIndex) {
            return this.indexBuilder.get();
        }
        throw new ExcelHandleException(ExcelHandleErrorInfo.not_index_column, new Object[0]);
    }

    @Override
    public int compareTo(ExportTitleParam exportTitleParam) {
        return new BigDecimal(this.order).compareTo(new BigDecimal(exportTitleParam.order));
    }

    public double getOrder() {
        return this.order;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<ExportTitleParam> getChildren() {
        return this.children;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public boolean isFillSame() {
        return this.fillSame;
    }

    public String getFillValue() {
        return this.fillValue;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public Field getEntityField() {
        return this.entityField;
    }

    public IndexBuilder getIndexBuilder() {
        return this.indexBuilder;
    }

    public Method getEnumMethod() {
        return this.enumMethod;
    }

    public ExportTitleParam setOrder(double order) {
        this.order = order;
        return this;
    }

    public ExportTitleParam setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public ExportTitleParam setWidth(int width) {
        this.width = width;
        return this;
    }

    public ExportTitleParam setHeight(int height) {
        this.height = height;
        return this;
    }

    public ExportTitleParam setChildren(List<ExportTitleParam> children) {
        this.children = children;
        return this;
    }

    public ExportTitleParam setIndex(boolean isIndex) {
        this.isIndex = isIndex;
        return this;
    }

    public ExportTitleParam setMerge(boolean merge) {
        this.merge = merge;
        return this;
    }

    public ExportTitleParam setFillSame(boolean fillSame) {
        this.fillSame = fillSame;
        return this;
    }

    public ExportTitleParam setFillValue(String fillValue) {
        this.fillValue = fillValue;
        return this;
    }

    public ExportTitleParam setCollection(boolean isCollection) {
        this.isCollection = isCollection;
        return this;
    }

    public ExportTitleParam setEntityField(Field entityField) {
        this.entityField = entityField;
        return this;
    }

    public ExportTitleParam setIndexBuilder(IndexBuilder indexBuilder) {
        this.indexBuilder = indexBuilder;
        return this;
    }

    public ExportTitleParam setEnumMethod(Method enumMethod) {
        this.enumMethod = enumMethod;
        return this;
    }

    public ExportTitleParam() {
    }

    @Override
    public String toString() {
        return "ExportTitleParam(super=" + super.toString() + ", order=" + this.getOrder() + ", groupName=" + this.getGroupName() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", children=" + this.getChildren() + ", isIndex=" + this.isIndex() + ", merge=" + this.isMerge() + ", fillSame=" + this.isFillSame() + ", fillValue=" + this.getFillValue() + ", isCollection=" + this.isCollection() + ", entityField=" + this.getEntityField() + ", indexBuilder=" + this.getIndexBuilder() + ", enumMethod=" + this.getEnumMethod() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportTitleParam)) {
            return false;
        }
        ExportTitleParam other = (ExportTitleParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getOrder(), other.getOrder()) != 0) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        List<ExportTitleParam> this$children = this.getChildren();
        List<ExportTitleParam> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        if (this.isIndex() != other.isIndex()) {
            return false;
        }
        if (this.isMerge() != other.isMerge()) {
            return false;
        }
        if (this.isFillSame() != other.isFillSame()) {
            return false;
        }
        String this$fillValue = this.getFillValue();
        String other$fillValue = other.getFillValue();
        if (this$fillValue == null ? other$fillValue != null : !this$fillValue.equals(other$fillValue)) {
            return false;
        }
        if (this.isCollection() != other.isCollection()) {
            return false;
        }
        Field this$entityField = this.getEntityField();
        Field other$entityField = other.getEntityField();
        if (this$entityField == null ? other$entityField != null : !((Object)this$entityField).equals(other$entityField)) {
            return false;
        }
        IndexBuilder this$indexBuilder = this.getIndexBuilder();
        IndexBuilder other$indexBuilder = other.getIndexBuilder();
        if (this$indexBuilder == null ? other$indexBuilder != null : !this$indexBuilder.equals(other$indexBuilder)) {
            return false;
        }
        Method this$enumMethod = this.getEnumMethod();
        Method other$enumMethod = other.getEnumMethod();
        return !(this$enumMethod == null ? other$enumMethod != null : !((Object)this$enumMethod).equals(other$enumMethod));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExportTitleParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $order = Double.doubleToLongBits(this.getOrder());
        result = result * 59 + (int)($order >>> 32 ^ $order);
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        List<ExportTitleParam> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        result = result * 59 + (this.isIndex() ? 79 : 97);
        result = result * 59 + (this.isMerge() ? 79 : 97);
        result = result * 59 + (this.isFillSame() ? 79 : 97);
        String $fillValue = this.getFillValue();
        result = result * 59 + ($fillValue == null ? 43 : $fillValue.hashCode());
        result = result * 59 + (this.isCollection() ? 79 : 97);
        Field $entityField = this.getEntityField();
        result = result * 59 + ($entityField == null ? 43 : ((Object)$entityField).hashCode());
        IndexBuilder $indexBuilder = this.getIndexBuilder();
        result = result * 59 + ($indexBuilder == null ? 43 : $indexBuilder.hashCode());
        Method $enumMethod = this.getEnumMethod();
        result = result * 59 + ($enumMethod == null ? 43 : ((Object)$enumMethod).hashCode());
        return result;
    }
}

