/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handle;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Workbook;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.enums.ExportHandleErrorInfo;
import top.lshaci.framework.excel.exception.ExportHandleException;
import top.lshaci.framework.excel.service.ExportService;

public class ExportHandler {
    public static <E> Workbook export(Class<E> cls, List<E> datas, ExportSheetParam sheetParam, ExportService exportService) {
        if (Objects.isNull(cls)) {
            throw new ExportHandleException(ExportHandleErrorInfo.entity_is_null, new Object[0]);
        }
        sheetParam = Optional.ofNullable(sheetParam).orElse(ExportSheetParam.build(cls.getAnnotation(ExportSheet.class)));
        exportService = Optional.ofNullable(exportService).orElseGet(ExportService::get);
        return exportService.create(cls, datas, sheetParam);
    }
}

