/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.handle;

import cn.hutool.core.io.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ImportSheetParam;
import top.lshaci.framework.excel.enums.ImportHandleErrorInfo;
import top.lshaci.framework.excel.exception.ImportHandleException;
import top.lshaci.framework.excel.service.impl.DefaultImportService;
import top.lshaci.framework.utils.FileTypeUtil;
import top.lshaci.framework.utils.enums.FileType;

public class ImportHandler {
    private static final Logger log = LoggerFactory.getLogger(ImportHandler.class);
    private static final List<FileType> ALLOW_FILE_TYPES = Arrays.asList(FileType.XLSX_DOCX, FileType.XLS_DOC, FileType.WPS, FileType.WPSX);

    public static <E> List<E> parse(InputStream is, Class<E> cls) {
        return ImportHandler.parse(is, cls, null);
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls, ImportSheetParam sheetParam) {
        ImportHandler.verifyParam(is, cls);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IoUtil.copy((InputStream)is, (OutputStream)buffer);
        Workbook workbook = ImportHandler.getWorkBook(buffer);
        return new DefaultImportService(cls, workbook, sheetParam).fetch();
    }

    private static void verifyParam(InputStream is, Class<?> cls) {
        if (Objects.isNull(cls)) {
            throw new ImportHandleException(ImportHandleErrorInfo.entity_is_null, new Object[0]);
        }
        if (Objects.isNull(is)) {
            throw new ImportHandleException(ImportHandleErrorInfo.data_is_null, new Object[0]);
        }
    }

    private static Workbook getWorkBook(ByteArrayOutputStream buffer) {
        FileType fileType = ImportHandler.getFileType(buffer);
        XSSFWorkbook workbook = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());){
            if (FileType.XLSX_DOCX.equals((Object)fileType) || FileType.WPSX.equals((Object)fileType)) {
                workbook = new XSSFWorkbook((InputStream)is);
            }
            if (FileType.XLS_DOC.equals((Object)fileType) || FileType.WPS.equals((Object)fileType)) {
                workbook = new HSSFWorkbook((InputStream)is);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efaExcel\u5de5\u4f5c\u7c3f\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        if (workbook == null) {
            throw new ImportHandleException(ImportHandleErrorInfo.workbook_is_null, new Object[0]);
        }
        return workbook;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileType getFileType(ByteArrayOutputStream buffer) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());){
            FileType fileType2 = FileTypeUtil.getType((InputStream)is);
            if (!ALLOW_FILE_TYPES.contains(fileType2)) throw new ImportHandleException(ImportHandleErrorInfo.not_excel, new Object[0]);
            FileType fileType = fileType2;
            return fileType;
        }
        catch (Exception e) {
            log.error(ImportHandleErrorInfo.fetch_excel_type_error.getMsg(), (Throwable)e);
            throw new ImportHandleException(ImportHandleErrorInfo.fetch_excel_type_error, new Object[0]);
        }
    }
}

