/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.helper;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DatePrinter;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ImportTitleParam;
import top.lshaci.framework.excel.helper.BaseValueUtil;
import top.lshaci.framework.utils.StringConverterUtils;

public class ImportValueHelper
extends BaseValueUtil {
    private static final Logger log = LoggerFactory.getLogger(ImportValueHelper.class);

    public static String get(Cell cell) {
        String value;
        if (Objects.isNull(cell)) {
            return null;
        }
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case FORMULA: {
                value = cell.getCellFormula();
                break;
            }
            case NUMERIC: {
                if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
                    value = DateUtil.format((Date)cell.getDateCellValue(), (DatePrinter)DatePattern.NORM_DATETIME_MS_FORMAT);
                    break;
                }
            }
            default: {
                cell.setCellType(CellType.STRING);
                value = cell.getStringCellValue();
            }
        }
        return Objects.isNull(value) ? null : value.trim();
    }

    public static Object getTargetValue(Cell cell, ImportTitleParam titleParam) {
        String cellValue = ImportValueHelper.getCellValue(cell, titleParam);
        if (Objects.isNull(cellValue)) {
            return null;
        }
        if (Objects.nonNull(titleParam.getConvertMethod())) {
            return ImportValueHelper.getConvertValue(titleParam.getConvertClass(), titleParam.getConvertMethod(), cellValue);
        }
        return StringConverterUtils.getTargetValue(titleParam.getField().getType(), (String)cellValue);
    }

    private static String getCellValue(Cell cell, ImportTitleParam titleParam) {
        String value = ImportValueHelper.get(cell);
        if (Objects.isNull(value)) {
            return null;
        }
        value = ImportValueHelper.replace(value, titleParam);
        if (MapUtils.isNotEmpty((Map)titleParam.getReplaceMap()) && Objects.isNull(value = (String)titleParam.getReplaceMap().get(value))) {
            log.warn("\u66ff\u6362\u540e\u5355\u5143\u683c\u7684\u503c\u4e3a\u7a7a, \u4e0d\u4f5c\u5176\u5b83\u5904\u7406");
            return null;
        }
        return value;
    }

    private static String replace(String value, ImportTitleParam titleParam) {
        String regex = "^" + titleParam.getPrefix() + "(.*)" + titleParam.getSuffix() + "$";
        return value.replaceAll(regex, "$1");
    }
}

