/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.service;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import top.lshaci.framework.excel.annotation.ExportSheet;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.entity.ExportTitleParam;
import top.lshaci.framework.excel.enums.ExcelType;
import top.lshaci.framework.excel.service.impl.DefaultExportService;

@FunctionalInterface
public interface ExportService {
    public Workbook create(Class<?> var1, List<?> var2, ExportSheetParam var3);

    public static ExportService get() {
        return new DefaultExportService();
    }

    default public Predicate<ExportTitleParam> columnFilter() {
        return t -> true;
    }

    default public Sheet sheet(Workbook workbook, ExportSheetParam sheetParam, int sheetNumber) {
        Integer number = sheetParam.getNumber();
        String name = sheetParam.getName();
        if (Objects.equals(1, number)) {
            return workbook.createSheet(name);
        }
        return workbook.createSheet(name + "_" + sheetNumber);
    }

    default public Workbook workbook(Class<?> cls) {
        ExportSheet exportSheet = cls.getAnnotation(ExportSheet.class);
        if (Objects.isNull(exportSheet)) {
            return new XSSFWorkbook();
        }
        if (ExcelType.XLSX.equals((Object)exportSheet.type())) {
            return new XSSFWorkbook();
        }
        return new HSSFWorkbook();
    }

    default public void afterSetColumnWidth() {
    }

    default public void afterSetSheetTitle() {
    }

    default public void afterSetColumnTitles() {
    }

    default public void afterSetRowContent() {
    }
}

