/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.service.impl;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.annotation.ExcelEntity;
import top.lshaci.framework.excel.annotation.ExportTitle;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.entity.ExportTitleParam;
import top.lshaci.framework.excel.enums.ExportHandleErrorInfo;
import top.lshaci.framework.excel.exception.ExportHandleException;
import top.lshaci.framework.excel.helper.ExportValueHelper;
import top.lshaci.framework.excel.service.ExportService;

public class DefaultExportService
implements ExportService {
    private static final Logger log = LoggerFactory.getLogger(DefaultExportService.class);
    protected Class<?> cls;
    protected List<?> datas;
    protected Workbook workbook;
    protected ExportSheetParam sheetParam;
    protected List<ExportTitleParam> titleParams;
    protected List<ExportTitleParam> contentParams;
    protected int maxRowHeight;
    protected int crn;
    protected Sheet sheet;
    protected CellStyle sheetTitleStyle;
    protected CellStyle columnTitleStyle;
    protected CellStyle contentStyle;
    protected ExportTitleParam collectionTitleParam;

    @Override
    public Workbook create(Class<?> cls, List<?> datas, ExportSheetParam sheetParam) {
        this.init(cls, datas, sheetParam);
        this.handleTitleParams();
        this.fillData();
        return this.workbook;
    }

    protected void fillData() {
        this.maxRowHeight = this.contentParams.stream().mapToInt(ExportTitleParam::getHeight).max().orElse(-1);
        Stream.iterate(1, n -> n + 1).limit(this.sheetParam.getNumber().intValue()).forEach(n -> {
            this.crn = 0;
            this.sheetParam.getIndexBuilder().reset();
            this.sheet = this.sheet(this.workbook, this.sheetParam, (int)n);
            this.setColumnWidth();
            this.afterSetColumnWidth();
            this.setSheetTitle();
            this.afterSetSheetTitle();
            this.setColumnTitles();
            this.afterSetColumnTitles();
            if (CollectionUtils.isEmpty(this.datas)) {
                return;
            }
            if (this.sheetParam.isFreezeTitle()) {
                this.sheet.createFreezePane(0, this.crn, 0, this.crn);
            }
            int size = this.sheetParam.getSize();
            int end = Math.min(n * size, this.datas.size());
            this.datas.subList((n - 1) * size, end).forEach(this::setRowContent);
            this.afterSetRowContent();
        });
    }

    protected void setRowContent(Object data) {
        if (Objects.nonNull(this.collectionTitleParam)) {
            this.handleHasCollection(data);
        } else {
            Row row = this.sheet.createRow(this.crn++);
            this.setRowHeight(row);
            AtomicInteger i = new AtomicInteger();
            this.contentParams.forEach(t -> this.setContentCellValue(row, i.getAndIncrement(), ExportValueHelper.fetch(t, data), (ExportTitleParam)t));
        }
    }

    protected void handleHasCollection(Object data) {
        Row row = this.sheet.createRow(this.crn);
        this.setRowHeight(row);
        Collection collectionValue = (Collection)ReflectUtil.getFieldValue((Object)data, (Field)this.collectionTitleParam.getEntityField());
        block0: for (int i = 0; i < this.contentParams.size(); ++i) {
            ExportTitleParam titleParam = this.contentParams.get(i);
            if (CollectionUtils.isEmpty((Collection)collectionValue)) {
                String cellValue = titleParam.isCollection() ? "" : ExportValueHelper.fetch(titleParam, data);
                this.setContentCellValue(row, i, cellValue, titleParam);
                continue;
            }
            int crn = this.crn;
            for (Object value : collectionValue) {
                String cellValue;
                if (titleParam.isCollection()) {
                    cellValue = Objects.isNull(value) ? "" : value.toString();
                    cellValue = Objects.isNull(titleParam.getMethod()) ? cellValue : ExportValueHelper.fetch(titleParam, value);
                } else {
                    cellValue = ExportValueHelper.fetch(titleParam, data);
                }
                Row nextRow = this.sheet.getRow(crn) == null ? this.sheet.createRow(crn) : this.sheet.getRow(crn);
                this.setRowHeight(nextRow);
                if (!titleParam.isCollection() && collectionValue.size() > 1 && titleParam.isMerge()) {
                    this.cellMerge(row, this.contentStyle, cellValue, this.crn, this.crn + collectionValue.size() - 1, i, i);
                    continue block0;
                }
                if (!titleParam.isCollection() && !titleParam.isFillSame() && crn != this.crn) {
                    cellValue = titleParam.getFillValue();
                }
                this.setContentCellValue(nextRow, i, cellValue, titleParam);
                ++crn;
            }
        }
        this.crn += CollectionUtils.isEmpty((Collection)collectionValue) ? 1 : collectionValue.size();
    }

    protected void setRowHeight(Row row) {
        if (this.maxRowHeight > 0) {
            row.setHeight((short)(this.maxRowHeight * 20));
        }
    }

    protected void setContentCellValue(Row row, int columnNumber, String cellValue, ExportTitleParam titleParam) {
        Cell cell = row.createCell(columnNumber);
        cell.setCellValue(cellValue);
        cell.setCellStyle(this.contentStyle);
    }

    protected void setColumnTitles() {
        Row row1 = this.sheet.createRow(this.crn);
        row1.setHeight(this.sheetParam.getColumnTitleHeight());
        if (this.contentParams.size() > this.titleParams.size()) {
            Row row2 = this.sheet.createRow(this.crn + 1);
            row2.setHeight(this.sheetParam.getColumnTitleHeight());
            this.setColumnTitles(row1, row2);
            this.crn += 2;
        } else {
            AtomicInteger i = new AtomicInteger();
            this.titleParams.forEach(t -> this.columnTitleCell(row1, i.getAndIncrement(), t.getTitle()));
            ++this.crn;
        }
    }

    protected void setColumnTitles(Row row1, Row row2) {
        AtomicInteger cn = new AtomicInteger();
        for (ExportTitleParam titleParam : this.titleParams) {
            int n;
            List<ExportTitleParam> children = titleParam.getChildren();
            if (CollectionUtils.isEmpty(children)) {
                n = cn.getAndIncrement();
                this.cellMerge(row1, this.columnTitleStyle, titleParam.getTitle(), this.crn, this.crn + 1, n, n);
                continue;
            }
            n = cn.get();
            this.cellMerge(row1, this.columnTitleStyle, titleParam.getTitle(), this.crn, this.crn, n, n + children.size() - 1);
            children.forEach(c -> this.columnTitleCell(row2, cn.getAndIncrement(), c.getTitle()));
        }
    }

    protected void columnTitleCell(Row row, int cn, String title) {
        Cell childrenCell = row.createCell(cn);
        childrenCell.setCellValue(title);
        childrenCell.setCellStyle(this.columnTitleStyle);
    }

    protected void setSheetTitle() {
        String title = this.sheetParam.getTitle();
        if (StrUtil.isBlank((CharSequence)title)) {
            return;
        }
        Row row = this.sheet.createRow(this.crn++);
        row.setHeight(this.sheetParam.getTitleHeight());
        this.cellMerge(row, this.sheetTitleStyle, title, 0, 0, 0, this.contentParams.size() - 1);
    }

    protected void setColumnWidth() {
        this.sheet.setDefaultColumnWidth(12);
        AtomicInteger i = new AtomicInteger();
        this.contentParams.forEach(t -> this.sheet.setColumnWidth(i.getAndIncrement(), t.getWidth() * 256));
    }

    protected void init(Class<?> cls, List<?> datas, ExportSheetParam sheetParam) {
        this.cls = cls;
        this.datas = datas;
        int total = CollectionUtils.isEmpty(datas) ? 0 : datas.size();
        this.sheetParam = sheetParam.setSizeAndNumber(total);
        this.workbook = this.workbook(cls);
        this.handleStyle();
    }

    protected void cellMerge(Row row, CellStyle cellStyle, String value, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.sheet.addMergedRegionUnsafe(region);
        Cell cell = row.createCell(firstCol);
        cell.setCellValue(value);
        cell.setCellStyle(cellStyle);
        this.sheetParam.getCellStyleBuilder().setMergeCellBorder(region, this.sheet);
    }

    protected void handleTitleParams() {
        List<ExportTitleParam> titleParams = this.fetchTitleParams(this.cls);
        titleParams.addAll(this.getEntities(this.cls));
        titleParams.addAll(this.getCollections(this.cls));
        if (this.sheetParam.isAddIndex()) {
            titleParams.add(ExportTitleParam.indexTitle(this.sheetParam));
        }
        ArrayList groupTitleParams = new ArrayList();
        titleParams.stream().filter(e -> StrUtil.isNotBlank((CharSequence)e.getGroupName())).sorted().collect(Collectors.groupingBy(ExportTitleParam::getGroupName)).forEach((k, v) -> {
            List<ExportTitleParam> children = v.stream().sorted().collect(Collectors.toList());
            ExportTitleParam titleParam = new ExportTitleParam().setChildren(children).setOrder(((ExportTitleParam)v.get(0)).getOrder());
            titleParam.setTitle((String)k);
            groupTitleParams.add(titleParam);
        });
        this.titleParams = Stream.concat(titleParams.stream().filter(e -> StrUtil.isBlank((CharSequence)e.getGroupName())), groupTitleParams.stream()).filter(this.columnFilter()).sorted().collect(Collectors.toList());
        this.contentParams = this.titleParams.stream().flatMap(e -> {
            if (CollectionUtils.isEmpty(e.getChildren())) {
                return Stream.of(e);
            }
            return e.getChildren().stream();
        }).collect(Collectors.toList());
        this.collectionTitleParam = this.contentParams.stream().filter(ExportTitleParam::isCollection).findFirst().orElse(null);
    }

    protected List<ExportTitleParam> fetchTitleParams(Class<?> cls) {
        HashMap<String, ExportTitleParam> titleParamMap = new HashMap<String, ExportTitleParam>();
        this.getFields(cls, titleParamMap);
        this.getMethods(cls, titleParamMap);
        return new ArrayList<ExportTitleParam>(titleParamMap.values());
    }

    protected void getFields(Class<?> cls, Map<String, ExportTitleParam> titleParamMap) {
        if (cls == Object.class) {
            return;
        }
        Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return !exportTitle.isEntity() && !exportTitle.isCollection();
        }).forEach(f -> {
            if (titleParamMap.get(f.getName()) == null) {
                titleParamMap.put(f.getName(), new ExportTitleParam((Field)f, cls));
            }
        });
        this.getFields(cls.getSuperclass(), titleParamMap);
    }

    protected void getMethods(Class<?> cls, Map<String, ExportTitleParam> titleParamMap) {
        if (cls == Object.class) {
            return;
        }
        Arrays.stream(cls.getMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ExportTitle.class))).filter(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return !exportTitle.isEntity() && !exportTitle.isCollection();
        }).forEach(m -> {
            if (titleParamMap.get(m.getName()) == null) {
                titleParamMap.put(m.getName(), new ExportTitleParam((Method)m));
            }
        });
        this.getMethods(cls.getSuperclass(), titleParamMap);
    }

    protected List<ExportTitleParam> getEntities(Class<?> cls) {
        return Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isEntity()).filter(f -> {
            ExcelEntity excelEntity = f.getType().getAnnotation(ExcelEntity.class);
            if (Objects.isNull(excelEntity)) {
                log.error("{}\u672a\u4f7f\u7528ExcelEntity\u6ce8\u89e3\u6807\u8bb0", f.getType());
                throw new ExportHandleException(ExportHandleErrorInfo.not_excel_entity, new Object[0]);
            }
            return true;
        }).flatMap(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            return this.fetchTitleParams(f.getType()).stream().map(e -> e.setEntityField((Field)f).setGroupName(exportTitle.title()).setOrder((double)exportTitle.order() + e.getOrder() / 100.0));
        }).collect(Collectors.toList());
    }

    protected List<ExportTitleParam> getCollections(Class<?> cls) {
        long count = Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isCollection()).count();
        if (count > 1L) {
            throw new ExportHandleException(ExportHandleErrorInfo.only_one_collection, new Object[0]);
        }
        return Arrays.stream(cls.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ExportTitle.class))).filter(f -> f.getAnnotation(ExportTitle.class).isCollection()).filter(f -> {
            if (!Collection.class.isAssignableFrom(f.getType())) {
                log.error("\u4f7f\u7528ExportTitle\u6ce8\u89e3\u6807\u8bb0\u7684\u5b57\u6bb5{}\u4e0d\u662f\u96c6\u5408\u7c7b\u578b", (Object)f.getName());
                throw new ExportHandleException(ExportHandleErrorInfo.not_collection, new Object[0]);
            }
            return true;
        }).flatMap(f -> {
            ExportTitle exportTitle = f.getAnnotation(ExportTitle.class);
            Class fieldGenericType = (Class)TypeUtil.getTypeArgument(f.getType());
            ExcelEntity excelEntity = fieldGenericType.getAnnotation(ExcelEntity.class);
            if (Objects.nonNull(excelEntity)) {
                return this.fetchTitleParams(fieldGenericType).stream().map(e -> e.setEntityField((Field)f).setCollection(true).setGroupName(exportTitle.title()).setOrder((double)exportTitle.order() + e.getOrder() / 100.0));
            }
            ExportTitleParam titleParam = new ExportTitleParam((Field)f, cls).setCollection(true).setEntityField((Field)f);
            titleParam.setMethod(null);
            return Stream.of(titleParam);
        }).collect(Collectors.toList());
    }

    protected void handleStyle() {
        String fontName = this.sheetParam.getFontName();
        this.sheetTitleStyle = this.sheetParam.getCellStyleBuilder().sheetTitleStyle(this.workbook, fontName);
        this.columnTitleStyle = this.sheetParam.getCellStyleBuilder().columnTitleStyle(this.workbook, fontName);
        this.contentStyle = this.sheetParam.getCellStyleBuilder().contentStyle(this.workbook, fontName);
    }
}

