/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ExportSheetParam;
import top.lshaci.framework.excel.enums.ExportHandleErrorInfo;
import top.lshaci.framework.excel.exception.ExportHandleException;
import top.lshaci.framework.excel.handle.ExportHandler;
import top.lshaci.framework.excel.service.ExportService;

public class ExcelExportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelExportUtils.class);

    public static <E> void export(Class<E> cls, List<E> datas, OutputStream os) {
        ExcelExportUtils.export(cls, datas, os, null, null);
    }

    public static <E> void export(Class<E> cls, List<E> datas, OutputStream os, ExportService exportService) {
        ExcelExportUtils.export(cls, datas, os, null, exportService);
    }

    public static <E> void export(Class<E> cls, List<E> datas, OutputStream os, ExportSheetParam sheetParam) {
        ExcelExportUtils.export(cls, datas, os, sheetParam, null);
    }

    public static <E> void export(Class<E> cls, List<E> datas, OutputStream os, ExportSheetParam sheetParam, ExportService exportService) {
        try (Workbook workbook = ExportHandler.export(cls, datas, sheetParam, exportService);){
            workbook.write(os);
        }
        catch (IOException e) {
            log.error(ExportHandleErrorInfo.failure.getMsg(), (Throwable)e);
            throw new ExportHandleException(ExportHandleErrorInfo.failure, new Object[0]);
        }
    }
}

