/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.excel.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.excel.entity.ImportSheetParam;
import top.lshaci.framework.excel.enums.ImportHandleErrorInfo;
import top.lshaci.framework.excel.exception.ImportHandleException;
import top.lshaci.framework.excel.handle.ImportHandler;

public class ExcelImportUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelImportUtils.class);

    public static <E> List<E> parse(File file, Class<E> cls) {
        return ExcelImportUtils.parse(file, cls, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <E> List<E> parse(File file, Class<E> cls, ImportSheetParam sheetParam) {
        try (FileInputStream is = new FileInputStream(file);){
            List<E> list = ExcelImportUtils.parse(is, cls, sheetParam);
            return list;
        }
        catch (IOException e) {
            log.error(ImportHandleErrorInfo.failure.getMsg(), (Throwable)e);
            throw new ImportHandleException(ImportHandleErrorInfo.failure, new Object[0]);
        }
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls) {
        return ExcelImportUtils.parse(is, cls, null);
    }

    public static <E> List<E> parse(InputStream is, Class<E> cls, ImportSheetParam sheetParam) {
        return ImportHandler.parse(is, cls, sheetParam);
    }
}

