/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs;

import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.fastdfs.FastDFSClient;
import top.lshaci.framework.fastdfs.TrackerServerPool;
import top.lshaci.framework.fastdfs.properties.FastDFSProperties;

@Configuration
@EnableConfigurationProperties(value={FastDFSProperties.class})
@ConditionalOnProperty(prefix="spring.fastdfs", value={"enabled"}, havingValue="true")
public class FastDFSClientConfig {
    private static final Logger log = LoggerFactory.getLogger(FastDFSClientConfig.class);
    @Autowired
    private FastDFSProperties properties;

    @PostConstruct
    public void initPool() throws Exception {
        log.debug("Start tracker server pool config.");
        TrackerServerPool.config = this.properties.getConfig();
        int minStorageConnection = this.properties.getMinStorageConnection();
        int maxStorageConnection = this.properties.getMaxStorageConnection();
        if (maxStorageConnection < 0) {
            maxStorageConnection = 8;
        }
        if (minStorageConnection < 0 || minStorageConnection > maxStorageConnection) {
            minStorageConnection = 2;
        }
        TrackerServerPool.minStorageConnection = minStorageConnection;
        TrackerServerPool.maxStorageConnection = maxStorageConnection;
        TrackerServerPool.initPool();
        log.debug("Tracker server pool config successfully.");
    }

    @PostConstruct
    public void setMaxFileSize() throws Exception {
        String fileServerAddr;
        log.debug("Set fast dfs client.");
        int maxFileSize = this.properties.getMaxFileSize();
        if (maxFileSize < 0) {
            maxFileSize = 0x100000;
        }
        if (StringUtils.isBlank((CharSequence)(fileServerAddr = this.properties.getFileServerAddr()))) {
            throw new Exception("The file server address must not be empty!");
        }
        FastDFSClient.maxFileSize = maxFileSize;
        FastDFSClient.fileServerAddr = fileServerAddr.trim();
        log.debug("The fast dfs client info: \n\t{}", (Object)FastDFSClient.info());
    }
}

