/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs;

import java.io.IOException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.common.MyException;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.fastdfs.TrackerServerFactory;
import top.lshaci.framework.fastdfs.enums.ErrorCode;
import top.lshaci.framework.fastdfs.exception.FastDFSException;

class TrackerServerPool {
    private static final Logger log = LoggerFactory.getLogger(TrackerServerPool.class);
    protected static String config;
    protected static int minStorageConnection;
    protected static int maxStorageConnection;
    protected static GenericObjectPool<TrackerServer> trackerServerPool;

    private TrackerServerPool() {
    }

    protected static void initPool() throws IOException, MyException {
        log.debug("Init tracker server pool...");
        ClientGlobal.initByProperties((String)config);
        log.debug("ClientGlobal configInfo: {}", (Object)ClientGlobal.configInfo());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMinIdle(minStorageConnection);
        poolConfig.setMaxTotal(maxStorageConnection);
        trackerServerPool = new GenericObjectPool((PooledObjectFactory)new TrackerServerFactory(), poolConfig);
    }

    protected static TrackerServer borrowObject() throws FastDFSException {
        TrackerServer trackerServer = null;
        try {
            trackerServer = (TrackerServer)trackerServerPool.borrowObject();
        }
        catch (Exception e) {
            log.error(ErrorCode.FETCH_TRACKER_SERVER_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FETCH_TRACKER_SERVER_FAILED);
        }
        if (trackerServer == null) {
            throw new FastDFSException(ErrorCode.FETCH_TRACKER_SERVER_FAILED);
        }
        return trackerServer;
    }

    protected static void returnObject(TrackerServer trackerServer) {
        if (trackerServer != null) {
            trackerServerPool.returnObject((Object)trackerServer);
        }
    }
}

