/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.enums;

import org.apache.commons.lang3.StringUtils;

public enum FileSuffixContentType {
    PNG("image/png"),
    GIF("image/gif"),
    BMP("image/bmp"),
    ICO("image/x-ico"),
    JPG("image/jpeg"),
    JPEG("image/jpeg"),
    ZIP("application/zip"),
    RAR("application/x-rar"),
    PDF("application/pdf"),
    PPT("application/vnd.ms-powerpoint"),
    PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
    XLS("application/vnd.ms-excel"),
    XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
    DOC("application/msword"),
    DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
    TXT("text/plain"),
    MP4("video/mp4"),
    FLV("video/x-flv");

    private String contentType;

    private FileSuffixContentType(String contentType) {
        this.contentType = contentType;
    }

    public static String getContentType(String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix)) {
            return null;
        }
        FileSuffixContentType fileSuffixContentType = FileSuffixContentType.valueOf(suffix.trim().toUpperCase());
        if (fileSuffixContentType != null) {
            return fileSuffixContentType.contentType;
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }
}

