/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.fastdfs.config.TrackerServerPool;
import top.lshaci.framework.fastdfs.properties.FastDFSProperties;
import top.lshaci.framework.fastdfs.util.FastDFSClient;

@Configuration
@EnableConfigurationProperties(value={FastDFSProperties.class})
@ConditionalOnProperty(prefix="framework.fastdfs", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class FastDFSClientConfig {
    private static final Logger log = LoggerFactory.getLogger(FastDFSClientConfig.class);
    @Autowired
    private FastDFSProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public TrackerServerPool trackerServerPool() throws Exception {
        TrackerServerPool pool = new TrackerServerPool();
        this.initPool(pool);
        return pool;
    }

    private void initPool(TrackerServerPool pool) throws Exception {
        log.debug("Start tracker server pool config.");
        pool.setConfig(this.properties.getConfig());
        long maxFileSize = this.properties.getMaxFileSize();
        int minStorageConnection = this.properties.getMinStorageConnection();
        int maxStorageConnection = this.properties.getMaxStorageConnection();
        if (maxStorageConnection < 0) {
            maxStorageConnection = 8;
        }
        if (minStorageConnection < 0 || minStorageConnection > maxStorageConnection) {
            minStorageConnection = 2;
        }
        if (maxFileSize < 0L) {
            maxFileSize = 0x100000L;
        }
        pool.setMaxFileSize(maxFileSize);
        pool.setMinStorageConnection(minStorageConnection);
        pool.setMaxStorageConnection(maxStorageConnection);
        String proxyAddress = this.properties.getReverseProxyAddress();
        if (StringUtils.isNotBlank((CharSequence)proxyAddress)) {
            pool.setReverseProxyAddress(proxyAddress.trim());
        }
        pool.init();
        log.debug("Tracker server pool config successfully.");
    }

    @Autowired
    public void setTrackerServerPool(TrackerServerPool trackerServerPool) {
        log.debug("Set fast dfs client.");
        FastDFSClient.pool = trackerServerPool;
        log.debug("The fast dfs client info: \n{}", (Object)FastDFSClient.info());
    }
}

