/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.config;

import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.fastdfs.config.TrackerServerFactory;
import top.lshaci.framework.fastdfs.enums.ErrorCode;
import top.lshaci.framework.fastdfs.exception.FastDFSException;

public class TrackerServerPool {
    private static final Logger log = LoggerFactory.getLogger(TrackerServerPool.class);
    private long maxFileSize;
    private String reverseProxyAddress;
    private String config;
    private int minStorageConnection;
    private int maxStorageConnection;
    private GenericObjectPool<TrackerServer> trackerServerPool;

    public void init() throws Exception {
        log.debug("Init tracker server pool...");
        ClientGlobal.initByProperties((String)this.config);
        log.debug("ClientGlobal configInfo: \n{}", (Object)ClientGlobal.configInfo());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMinIdle(this.minStorageConnection);
        poolConfig.setMaxTotal(this.maxStorageConnection);
        this.trackerServerPool = new GenericObjectPool((PooledObjectFactory)new TrackerServerFactory(), poolConfig);
    }

    public TrackerServer borrowObject() {
        TrackerServer trackerServer = null;
        try {
            trackerServer = (TrackerServer)this.trackerServerPool.borrowObject();
        }
        catch (Exception e) {
            log.error(ErrorCode.FETCH_TRACKER_SERVER_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FETCH_TRACKER_SERVER_FAILED);
        }
        if (trackerServer == null) {
            throw new FastDFSException(ErrorCode.FETCH_TRACKER_SERVER_FAILED);
        }
        return trackerServer;
    }

    public void returnObject(TrackerServer trackerServer) {
        if (trackerServer != null) {
            this.trackerServerPool.returnObject((Object)trackerServer);
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getReverseProxyAddress() {
        return this.reverseProxyAddress;
    }

    public String getConfig() {
        return this.config;
    }

    public int getMinStorageConnection() {
        return this.minStorageConnection;
    }

    public int getMaxStorageConnection() {
        return this.maxStorageConnection;
    }

    public GenericObjectPool<TrackerServer> getTrackerServerPool() {
        return this.trackerServerPool;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setReverseProxyAddress(String reverseProxyAddress) {
        this.reverseProxyAddress = reverseProxyAddress;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setMinStorageConnection(int minStorageConnection) {
        this.minStorageConnection = minStorageConnection;
    }

    public void setMaxStorageConnection(int maxStorageConnection) {
        this.maxStorageConnection = maxStorageConnection;
    }

    public void setTrackerServerPool(GenericObjectPool<TrackerServer> trackerServerPool) {
        this.trackerServerPool = trackerServerPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackerServerPool)) {
            return false;
        }
        TrackerServerPool other = (TrackerServerPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFileSize() != other.getMaxFileSize()) {
            return false;
        }
        String this$reverseProxyAddress = this.getReverseProxyAddress();
        String other$reverseProxyAddress = other.getReverseProxyAddress();
        if (this$reverseProxyAddress == null ? other$reverseProxyAddress != null : !this$reverseProxyAddress.equals(other$reverseProxyAddress)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        if (this.getMinStorageConnection() != other.getMinStorageConnection()) {
            return false;
        }
        if (this.getMaxStorageConnection() != other.getMaxStorageConnection()) {
            return false;
        }
        GenericObjectPool<TrackerServer> this$trackerServerPool = this.getTrackerServerPool();
        GenericObjectPool<TrackerServer> other$trackerServerPool = other.getTrackerServerPool();
        return !(this$trackerServerPool == null ? other$trackerServerPool != null : !this$trackerServerPool.equals(other$trackerServerPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackerServerPool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxFileSize = this.getMaxFileSize();
        result = result * 59 + (int)($maxFileSize >>> 32 ^ $maxFileSize);
        String $reverseProxyAddress = this.getReverseProxyAddress();
        result = result * 59 + ($reverseProxyAddress == null ? 43 : $reverseProxyAddress.hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        result = result * 59 + this.getMinStorageConnection();
        result = result * 59 + this.getMaxStorageConnection();
        GenericObjectPool<TrackerServer> $trackerServerPool = this.getTrackerServerPool();
        result = result * 59 + ($trackerServerPool == null ? 43 : $trackerServerPool.hashCode());
        return result;
    }

    public String toString() {
        return "TrackerServerPool(maxFileSize=" + this.getMaxFileSize() + ", reverseProxyAddress=" + this.getReverseProxyAddress() + ", config=" + this.getConfig() + ", minStorageConnection=" + this.getMinStorageConnection() + ", maxStorageConnection=" + this.getMaxStorageConnection() + ", trackerServerPool=" + this.getTrackerServerPool() + ")";
    }
}

