/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.properties;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="framework.fastdfs")
public class FastDFSProperties {
    private Boolean enabled = true;
    private String reverseProxyAddress;
    private String config = "fastdfs.properties";
    private int minStorageConnection = 2;
    private int maxStorageConnection = 8;
    private long maxFileSize = 0x100000L;

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = this.parseSize(maxFileSize);
    }

    private long parseSize(String size) {
        if (StringUtils.isBlank((CharSequence)size)) {
            return 0x100000L;
        }
        if ((size = size.toUpperCase()).endsWith("KB")) {
            return Long.valueOf(size.substring(0, size.length() - 2)) * 1024L;
        }
        if (size.endsWith("MB")) {
            return Long.valueOf(size.substring(0, size.length() - 2)) * 1024L * 1024L;
        }
        return Long.valueOf(size);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getReverseProxyAddress() {
        return this.reverseProxyAddress;
    }

    public String getConfig() {
        return this.config;
    }

    public int getMinStorageConnection() {
        return this.minStorageConnection;
    }

    public int getMaxStorageConnection() {
        return this.maxStorageConnection;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setReverseProxyAddress(String reverseProxyAddress) {
        this.reverseProxyAddress = reverseProxyAddress;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setMinStorageConnection(int minStorageConnection) {
        this.minStorageConnection = minStorageConnection;
    }

    public void setMaxStorageConnection(int maxStorageConnection) {
        this.maxStorageConnection = maxStorageConnection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FastDFSProperties)) {
            return false;
        }
        FastDFSProperties other = (FastDFSProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$reverseProxyAddress = this.getReverseProxyAddress();
        String other$reverseProxyAddress = other.getReverseProxyAddress();
        if (this$reverseProxyAddress == null ? other$reverseProxyAddress != null : !this$reverseProxyAddress.equals(other$reverseProxyAddress)) {
            return false;
        }
        String this$config = this.getConfig();
        String other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        if (this.getMinStorageConnection() != other.getMinStorageConnection()) {
            return false;
        }
        if (this.getMaxStorageConnection() != other.getMaxStorageConnection()) {
            return false;
        }
        return this.getMaxFileSize() == other.getMaxFileSize();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FastDFSProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $reverseProxyAddress = this.getReverseProxyAddress();
        result = result * 59 + ($reverseProxyAddress == null ? 43 : $reverseProxyAddress.hashCode());
        String $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        result = result * 59 + this.getMinStorageConnection();
        result = result * 59 + this.getMaxStorageConnection();
        long $maxFileSize = this.getMaxFileSize();
        result = result * 59 + (int)($maxFileSize >>> 32 ^ $maxFileSize);
        return result;
    }

    public String toString() {
        return "FastDFSProperties(enabled=" + this.getEnabled() + ", reverseProxyAddress=" + this.getReverseProxyAddress() + ", config=" + this.getConfig() + ", minStorageConnection=" + this.getMinStorageConnection() + ", maxStorageConnection=" + this.getMaxStorageConnection() + ", maxFileSize=" + this.getMaxFileSize() + ")";
    }
}

