/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.FileInfo;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient1;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import top.lshaci.framework.fastdfs.config.TrackerServerPool;
import top.lshaci.framework.fastdfs.enums.ErrorCode;
import top.lshaci.framework.fastdfs.enums.FileSuffixContentType;
import top.lshaci.framework.fastdfs.exception.FastDFSException;

public class FastDFSClient {
    private static final Logger log = LoggerFactory.getLogger(FastDFSClient.class);
    public static TrackerServerPool pool;

    private FastDFSClient() {
    }

    public static String uploadWithMultipart(MultipartFile file) {
        return FastDFSClient.uploadWithMultipart(file, null);
    }

    public static String uploadWithMultipart(MultipartFile file, Map<String, String> descriptions) {
        if (file == null || file.isEmpty()) {
            throw new FastDFSException(ErrorCode.FILE_IS_EMPTY);
        }
        try {
            return FastDFSClient.upload(file.getInputStream(), file.getOriginalFilename(), descriptions);
        }
        catch (IOException e) {
            log.error(ErrorCode.FILE_UPLOAD_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED);
        }
    }

    public static String uploadWithFilepath(String filepath) {
        return FastDFSClient.uploadWithFilepath(filepath, null);
    }

    public static String uploadWithFilepath(String filepath, Map<String, String> descriptions) {
        if (StringUtils.isBlank((CharSequence)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_IS_NULL);
        }
        File file = new File(filepath.trim());
        String path = null;
        try (FileInputStream is = new FileInputStream(file);){
            filepath = FastDFSClient.toLocal(filepath);
            String filename = filepath.substring(filepath.lastIndexOf("/") + 1);
            path = FastDFSClient.upload(is, filename, descriptions);
        }
        catch (IOException e) {
            log.error(ErrorCode.FILE_NOT_EXIST.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FILE_NOT_EXIST);
        }
        return path;
    }

    public static String uploadWithBase64(String base64) {
        return FastDFSClient.uploadWithBase64(base64, null, null);
    }

    public static String uploadWithBase64(String base64, String filename) {
        return FastDFSClient.uploadWithBase64(base64, filename, null);
    }

    public static String uploadWithBase64(String base64, String filename, Map<String, String> descriptions) {
        if (StringUtils.isBlank((CharSequence)base64)) {
            throw new FastDFSException(ErrorCode.FILE_IS_EMPTY);
        }
        return FastDFSClient.upload(new ByteArrayInputStream(Base64.decodeBase64((String)base64)), filename, descriptions);
    }

    public static String upload(InputStream is) {
        return FastDFSClient.upload(is, null);
    }

    public static String upload(InputStream is, String filename) {
        return FastDFSClient.upload(is, filename, null);
    }

    public static String upload(InputStream is, String filename, Map<String, String> descriptions) {
        FastDFSClient.verifyInputStream(is);
        filename = FastDFSClient.toLocal(filename);
        String path = null;
        NameValuePair[] nvps = FastDFSClient.createFileDescriptions(filename, descriptions);
        String suffix = FastDFSClient.getFilenameSuffix(filename);
        TrackerServer trackerServer = null;
        try {
            try (InputStream _is = is;){
                trackerServer = pool.borrowObject();
                StorageClient1 storageClient = new StorageClient1(trackerServer, null);
                byte[] fileBuff = new byte[_is.available()];
                _is.read(fileBuff, 0, fileBuff.length);
                path = storageClient.upload_file1(fileBuff, suffix, nvps);
                if (StringUtils.isBlank((CharSequence)path)) {
                    throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED);
                }
                log.debug("upload file success, return path is {}", (Object)path);
            }
            pool.returnObject(trackerServer);
        }
        catch (IOException | MyException e) {
            try {
                log.error(ErrorCode.FILE_UPLOAD_FAILED.getCode());
                throw new FastDFSException(ErrorCode.FILE_UPLOAD_FAILED);
            }
            catch (Throwable throwable) {
                pool.returnObject(trackerServer);
                throw throwable;
            }
        }
        return path;
    }

    private static void verifyInputStream(InputStream is) {
        if (is == null) {
            throw new FastDFSException(ErrorCode.FILE_IS_EMPTY);
        }
        try {
            if ((long)is.available() > pool.getMaxFileSize()) {
                throw new FastDFSException(ErrorCode.FILE_OUT_SIZE);
            }
        }
        catch (IOException e) {
            log.warn("Invoke available method error.", (Throwable)e);
        }
    }

    private static NameValuePair[] createFileDescriptions(String filename, Map<String, String> descriptions) {
        ArrayList<NameValuePair> nvpsList = new ArrayList<NameValuePair>();
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            nvpsList.add(new NameValuePair("filename", filename));
        }
        if (MapUtils.isNotEmpty(descriptions)) {
            descriptions.forEach((key, value) -> nvpsList.add(new NameValuePair(key, value)));
        }
        return (NameValuePair[])nvpsList.stream().toArray(NameValuePair[]::new);
    }

    public static void download(String filepath, HttpServletResponse response) {
        FastDFSClient.download(filepath, null, response);
    }

    public static void download(String filepath, String filename, HttpServletResponse response) {
        if (response == null) {
            throw new FastDFSException(ErrorCode.RESPONSE_IS_NULL);
        }
        filepath = FastDFSClient.toLocal(filepath.trim());
        if (StringUtils.isBlank((CharSequence)filename)) {
            filename = FastDFSClient.getOriginalFilename(filepath);
        }
        log.debug("Download file, the file path is: {}, filename: {}", (Object)filepath, (Object)filename);
        FastDFSClient.setResponseHeader(filename, response);
        try {
            FastDFSClient.write(filepath, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error(ErrorCode.FETCH_RESPONSE_STREAM_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FETCH_RESPONSE_STREAM_FAILED);
        }
    }

    private static void setResponseHeader(String filename, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            log.warn("Set response header failed, because the file name is blank.");
            return;
        }
        try {
            String encoderName = URLEncoder.encode(filename, "UTF-8");
            String contentType = FileSuffixContentType.getContentType(FastDFSClient.getFilenameSuffix(filename));
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                response.setContentType(contentType + ";charset=UTF-8");
            }
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Content-Disposition", "attachment;filename=" + encoderName);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Ignore.", (Throwable)e);
        }
    }

    public static void write(String filepath, OutputStream os) {
        FastDFSClient.verifyParameters(filepath, os);
        filepath = FastDFSClient.toLocal(filepath.trim());
        log.debug("Write file, the file path is: {}", (Object)filepath);
        TrackerServer trackerServer = pool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        byte[] fileByte = null;
        try {
            fileByte = storageClient.download_file1(filepath);
        }
        catch (IOException | MyException e) {
            log.error(ErrorCode.FILE_DOWNLOAD_FAILED.getCode(), e);
            throw new FastDFSException(ErrorCode.FILE_DOWNLOAD_FAILED);
        }
        finally {
            pool.returnObject(trackerServer);
        }
        if (fileByte == null) {
            log.error(ErrorCode.FILE_NOT_EXIST.getCode() + ": {}", (Object)filepath);
            throw new FastDFSException(ErrorCode.FILE_NOT_EXIST);
        }
        try (OutputStream _os = os;
             ByteArrayInputStream is = new ByteArrayInputStream(fileByte);){
            byte[] buffer = new byte[5120];
            int len = 0;
            while ((len = is.read(buffer)) > 0) {
                _os.write(buffer, 0, len);
            }
            _os.flush();
        }
        catch (IOException e) {
            log.error(ErrorCode.FILE_WRITE_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FILE_WRITE_FAILED);
        }
    }

    private static void verifyParameters(String filepath, OutputStream os) {
        FastDFSClient.verifyFilepath(filepath);
        if (os == null) {
            throw new FastDFSException(ErrorCode.OUTPUT_STREAM_IS_NULL);
        }
    }

    private static void verifyFilepath(String filepath) {
        if (StringUtils.isBlank((CharSequence)filepath)) {
            throw new FastDFSException(ErrorCode.FILE_PATH_IS_NULL);
        }
    }

    public static int deleteFile(String filepath) {
        FastDFSClient.verifyFilepath(filepath);
        TrackerServer trackerServer = pool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        try {
            int n = storageClient.delete_file1(filepath);
            return n;
        }
        catch (IOException | MyException e) {
            log.error(ErrorCode.FILE_DELETE_FAILED.getCode(), e);
            throw new FastDFSException(ErrorCode.FILE_DELETE_FAILED);
        }
        finally {
            pool.returnObject(trackerServer);
        }
    }

    public static FileInfo getFileInfo(String filepath) {
        TrackerServer trackerServer = pool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        try {
            FileInfo fileInfo = storageClient.get_file_info1(filepath);
            return fileInfo;
        }
        catch (IOException | MyException e) {
            log.error(ErrorCode.FETCH_FILE_INFO_FAILED.getCode(), e);
            throw new FastDFSException(ErrorCode.FETCH_FILE_INFO_FAILED);
        }
        finally {
            pool.returnObject(trackerServer);
        }
    }

    public static String getToken(String filepath, String httpSecretKey) {
        int ts = (int)Instant.now().getEpochSecond();
        String token = "null";
        try {
            token = ProtoCommon.getToken((String)FastDFSClient.getFilename(filepath), (int)ts, (String)httpSecretKey);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException | MyException e) {
            log.error(ErrorCode.FETCH_TOKEN_FAILED.getCode(), e);
            throw new FastDFSException(ErrorCode.FETCH_TOKEN_FAILED);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("token=").append(token).append("&ts=").append(ts);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getFileDescriptions(String filepath) {
        TrackerServer trackerServer = pool.borrowObject();
        StorageClient1 storageClient = new StorageClient1(trackerServer, null);
        Object[] nvps = null;
        try {
            nvps = storageClient.get_metadata1(filepath);
        }
        catch (IOException | MyException e) {
            log.warn("Error getting file description: {}", (Object)filepath);
        }
        finally {
            pool.returnObject(trackerServer);
        }
        Map<String, String> infoMap = null;
        if (ArrayUtils.isNotEmpty((Object[])nvps)) {
            infoMap = Arrays.stream(nvps).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (k1, k2) -> k1));
        }
        return infoMap;
    }

    private static String getOriginalFilename(String filepath) {
        Map<String, String> descriptions = FastDFSClient.getFileDescriptions(filepath);
        if (MapUtils.isNotEmpty(descriptions)) {
            return descriptions.get("filename");
        }
        return null;
    }

    private static String getFilenameSuffix(String filename) {
        String suffix = null;
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            if (filename.contains(".")) {
                suffix = filename.substring(filename.lastIndexOf(".") + 1);
            } else {
                log.error("The filename error without suffix : {}", (Object)filename);
            }
        }
        return suffix;
    }

    private static String toLocal(String path) {
        if (StringUtils.isNotBlank((CharSequence)path) && (path = path.replaceAll("\\\\", "/")).contains(".")) {
            String pre = path.substring(0, path.lastIndexOf(".") + 1);
            String suffix = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            path = pre + suffix;
        }
        return path;
    }

    private static String getFilename(String fileId) {
        String[] results = new String[2];
        StorageClient1.split_file_id((String)fileId, (String[])results);
        return results[1];
    }

    public static String getReverseProxyAddress() {
        return pool.getReverseProxyAddress();
    }

    public static String info() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n  reverse_proxy_address = ").append(pool.getReverseProxyAddress()).append("\n  max_file_size(byte) = ").append(pool.getMaxFileSize()).append("\n}");
        return sb.toString();
    }
}

