/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.config;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.fastdfs.config.TrackerServerFactory;
import top.lshaci.framework.fastdfs.enums.ErrorCode;
import top.lshaci.framework.fastdfs.exception.FastDFSException;
import top.lshaci.framework.fastdfs.properties.FrameworkFastDFSProperties;

public class TrackerServerPool {
    private static final Logger log = LoggerFactory.getLogger(TrackerServerPool.class);
    private long maxFileSize;
    private String reverseProxyAddress;
    private GenericObjectPool<TrackerServer> trackerServerPool;

    public TrackerServerPool(FrameworkFastDFSProperties properties) throws Exception {
        this.maxFileSize = properties.getMaxFileSize().toBytes();
        this.reverseProxyAddress = properties.getReverseProxyAddress();
        this.clientInit(properties.getProperties());
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMinIdle(properties.getMinIdle());
        poolConfig.setMaxIdle(properties.getMaxIdle());
        poolConfig.setMaxTotal(properties.getMinIdle());
        this.trackerServerPool = new GenericObjectPool((PooledObjectFactory)new TrackerServerFactory(), poolConfig);
    }

    private void clientInit(Map<String, String> properties) throws Exception {
        Properties fastDFSProperties = new Properties();
        if (MapUtils.isNotEmpty(properties)) {
            properties.forEach((k, v) -> fastDFSProperties.put("fastdfs." + k, v));
        }
        ClientGlobal.initByProperties((Properties)fastDFSProperties);
        log.debug("ClientGlobal configInfo: \n{}", (Object)ClientGlobal.configInfo());
    }

    public TrackerServer borrowObject() {
        try {
            return (TrackerServer)this.trackerServerPool.borrowObject();
        }
        catch (Exception e) {
            log.error(ErrorCode.FETCH_TRACKER_SERVER_FAILED.getCode(), (Throwable)e);
            throw new FastDFSException(ErrorCode.FETCH_TRACKER_SERVER_FAILED);
        }
    }

    public void returnObject(TrackerServer trackerServer) {
        if (trackerServer != null) {
            this.trackerServerPool.returnObject((Object)trackerServer);
        }
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getReverseProxyAddress() {
        return this.reverseProxyAddress;
    }

    public GenericObjectPool<TrackerServer> getTrackerServerPool() {
        return this.trackerServerPool;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setReverseProxyAddress(String reverseProxyAddress) {
        this.reverseProxyAddress = reverseProxyAddress;
    }

    public void setTrackerServerPool(GenericObjectPool<TrackerServer> trackerServerPool) {
        this.trackerServerPool = trackerServerPool;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackerServerPool)) {
            return false;
        }
        TrackerServerPool other = (TrackerServerPool)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxFileSize() != other.getMaxFileSize()) {
            return false;
        }
        String this$reverseProxyAddress = this.getReverseProxyAddress();
        String other$reverseProxyAddress = other.getReverseProxyAddress();
        if (this$reverseProxyAddress == null ? other$reverseProxyAddress != null : !this$reverseProxyAddress.equals(other$reverseProxyAddress)) {
            return false;
        }
        GenericObjectPool<TrackerServer> this$trackerServerPool = this.getTrackerServerPool();
        GenericObjectPool<TrackerServer> other$trackerServerPool = other.getTrackerServerPool();
        return !(this$trackerServerPool == null ? other$trackerServerPool != null : !this$trackerServerPool.equals(other$trackerServerPool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrackerServerPool;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxFileSize = this.getMaxFileSize();
        result = result * 59 + (int)($maxFileSize >>> 32 ^ $maxFileSize);
        String $reverseProxyAddress = this.getReverseProxyAddress();
        result = result * 59 + ($reverseProxyAddress == null ? 43 : $reverseProxyAddress.hashCode());
        GenericObjectPool<TrackerServer> $trackerServerPool = this.getTrackerServerPool();
        result = result * 59 + ($trackerServerPool == null ? 43 : $trackerServerPool.hashCode());
        return result;
    }

    public String toString() {
        return "TrackerServerPool(maxFileSize=" + this.getMaxFileSize() + ", reverseProxyAddress=" + this.getReverseProxyAddress() + ", trackerServerPool=" + this.getTrackerServerPool() + ")";
    }
}

