/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.lshaci.framework.fastdfs.config.TrackerServerPool;
import top.lshaci.framework.fastdfs.properties.FrameworkFastDFSProperties;
import top.lshaci.framework.fastdfs.util.FastDFSClient;

@Configuration
@EnableConfigurationProperties(value={FrameworkFastDFSProperties.class})
@ConditionalOnProperty(prefix="framework.fastdfs", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class FastDFSClientConfig {
    private static final Logger log = LoggerFactory.getLogger(FastDFSClientConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public TrackerServerPool trackerServerPool(FrameworkFastDFSProperties properties) throws Exception {
        log.debug("Config fast dfs tracker server pool.");
        TrackerServerPool trackerServerPool = new TrackerServerPool(properties);
        log.debug("Set fast dfs client.");
        FastDFSClient.pool = trackerServerPool;
        log.debug("The fast dfs client info: \n{}", (Object)FastDFSClient.info());
        return trackerServerPool;
    }
}

