/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fastdfs.properties;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="framework.fastdfs")
public class FrameworkFastDFSProperties {
    private boolean enabled = true;
    private String reverseProxyAddress;
    @Min(value=1L, message="The [framework.fastdfs.min-idle] must greater than 1!")
    private @Min(value=1L, message="The [framework.fastdfs.min-idle] must greater than 1!") int minIdle = 2;
    @Min(value=1L, message="The [framework.fastdfs.max-idle] must greater than 1!")
    private @Min(value=1L, message="The [framework.fastdfs.max-idle] must greater than 1!") int maxIdle = 8;
    @Min(value=1L, message="The [framework.fastdfs.max-total] must greater than 1!")
    private @Min(value=1L, message="The [framework.fastdfs.max-total] must greater than 1!") int maxTotal = 8;
    @NotNull(message="The [framework.fastdfs.max-file-size] must not be null!")
    private @NotNull(message="The [framework.fastdfs.max-file-size] must not be null!") DataSize maxFileSize = DataSize.ofMegabytes((long)1L);
    private Map<String, String> properties = new HashMap<String, String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getReverseProxyAddress() {
        return this.reverseProxyAddress;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public DataSize getMaxFileSize() {
        return this.maxFileSize;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReverseProxyAddress(String reverseProxyAddress) {
        this.reverseProxyAddress = reverseProxyAddress;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxFileSize(DataSize maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FrameworkFastDFSProperties)) {
            return false;
        }
        FrameworkFastDFSProperties other = (FrameworkFastDFSProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$reverseProxyAddress = this.getReverseProxyAddress();
        String other$reverseProxyAddress = other.getReverseProxyAddress();
        if (this$reverseProxyAddress == null ? other$reverseProxyAddress != null : !this$reverseProxyAddress.equals(other$reverseProxyAddress)) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        if (this.getMaxIdle() != other.getMaxIdle()) {
            return false;
        }
        if (this.getMaxTotal() != other.getMaxTotal()) {
            return false;
        }
        DataSize this$maxFileSize = this.getMaxFileSize();
        DataSize other$maxFileSize = other.getMaxFileSize();
        if (this$maxFileSize == null ? other$maxFileSize != null : !this$maxFileSize.equals(other$maxFileSize)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FrameworkFastDFSProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $reverseProxyAddress = this.getReverseProxyAddress();
        result = result * 59 + ($reverseProxyAddress == null ? 43 : $reverseProxyAddress.hashCode());
        result = result * 59 + this.getMinIdle();
        result = result * 59 + this.getMaxIdle();
        result = result * 59 + this.getMaxTotal();
        DataSize $maxFileSize = this.getMaxFileSize();
        result = result * 59 + ($maxFileSize == null ? 43 : $maxFileSize.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "FrameworkFastDFSProperties(enabled=" + this.isEnabled() + ", reverseProxyAddress=" + this.getReverseProxyAddress() + ", minIdle=" + this.getMinIdle() + ", maxIdle=" + this.getMaxIdle() + ", maxTotal=" + this.getMaxTotal() + ", maxFileSize=" + this.getMaxFileSize() + ", properties=" + this.getProperties() + ")";
    }
}

