/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fescar.filter;

import com.alibaba.fescar.core.context.RootContext;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class FescarRMRequestFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(FescarRMRequestFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String xid = RootContext.getXID();
        String requestXid = request.getHeader("fescar-XID");
        boolean bind = false;
        if (StringUtils.isBlank((CharSequence)xid) && StringUtils.isNotBlank((CharSequence)requestXid)) {
            RootContext.bind((String)requestXid);
            bind = true;
            log.info("Current request bind XID: {}", (Object)requestXid);
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            String unbindXid;
            if (bind && !Objects.equals(unbindXid = RootContext.unbind(), requestXid)) {
                log.info("XID is changed when request execute, check if it meets expectations please");
            }
        }
    }
}

