/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.fescar.interceptor;

import com.alibaba.fescar.core.context.RootContext;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class FescarRestInterceptor
implements RequestInterceptor,
ClientHttpRequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        String xid = RootContext.getXID();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            requestTemplate.header("fescar-XID", new String[]{xid});
        }
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String xid = RootContext.getXID();
        if (StringUtils.isNotBlank((CharSequence)xid)) {
            HttpHeaders headers = request.getHeaders();
            headers.put("fescar-XID", Collections.singletonList(xid));
        }
        return execution.execute(request, body);
    }
}

